/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resourcemgr.config.selectors;

import oadd.com.typesafe.config.Config;
import oadd.org.apache.drill.exec.resourcemgr.config.exception.RMConfigException;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.AbstractResourcePoolSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.AclSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.AndSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.DefaultSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.NotEqualSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.OrSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.ResourcePoolSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.TagSelector;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class ResourcePoolSelectorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourcePoolSelectorFactory.class);

    public static ResourcePoolSelector createSelector(Config selectorConfig) throws RMConfigException {
        AbstractResourcePoolSelector poolSelector = null;
        String selectorType = ResourcePoolSelector.SelectorType.DEFAULT.toString();
        try {
            if (selectorConfig == null) {
                poolSelector = new DefaultSelector();
            } else if (selectorConfig.hasPath(ResourcePoolSelector.SelectorType.TAG.toString())) {
                selectorType = ResourcePoolSelector.SelectorType.TAG.toString();
                poolSelector = new TagSelector(selectorConfig.getString(selectorType));
            } else if (selectorConfig.hasPath(ResourcePoolSelector.SelectorType.ACL.toString())) {
                selectorType = ResourcePoolSelector.SelectorType.ACL.toString();
                poolSelector = new AclSelector(selectorConfig.getConfig(selectorType));
            } else if (selectorConfig.hasPath(ResourcePoolSelector.SelectorType.OR.toString())) {
                selectorType = ResourcePoolSelector.SelectorType.OR.toString();
                poolSelector = new OrSelector(selectorConfig.getConfigList(selectorType));
            } else if (selectorConfig.hasPath(ResourcePoolSelector.SelectorType.AND.toString())) {
                selectorType = ResourcePoolSelector.SelectorType.AND.toString();
                poolSelector = new AndSelector(selectorConfig.getConfigList(selectorType));
            } else if (selectorConfig.hasPath(ResourcePoolSelector.SelectorType.NOT_EQUAL.toString())) {
                selectorType = ResourcePoolSelector.SelectorType.NOT_EQUAL.toString();
                poolSelector = new NotEqualSelector(selectorConfig.getConfig(selectorType));
            }
        }
        catch (Exception ex) {
            throw new RMConfigException(String.format("There is an error with value configuration for selector type %s", selectorType), ex);
        }
        if (poolSelector == null) {
            throw new RMConfigException(String.format("Configured selector is either empty or not supported. [Details: SelectorConfig: %s]", selectorConfig));
        }
        logger.debug("Created selector of type {}", (Object)poolSelector.getSelectorType().toString());
        return poolSelector;
    }
}

