/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger logger = LoggerFactory.getLogger(NamedThreadFactory.class);
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;

    public NamedThreadFactory(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.prefix + this.nextId.incrementAndGet());
        thread.setDaemon(true);
        try {
            if (thread.getPriority() != 10) {
                thread.setPriority(10);
            }
        }
        catch (Exception ignored) {
            logger.info("ignored exception " + ignored);
        }
        return thread;
    }
}

