/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import oadd.io.netty.channel.ChannelHandler;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class RpcExceptionHandler<C extends RemoteConnection>
implements ChannelHandler {
    static final Logger logger = LoggerFactory.getLogger(RpcExceptionHandler.class);
    private final C connection;

    public RpcExceptionHandler(C connection) {
        this.connection = connection;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!ctx.channel().isOpen() || cause.getMessage().equals("Connection reset by peer")) {
            logger.warn("Exception occurred with closed channel.  Connection: {}", (Object)this.connection.getName(), (Object)cause);
            return;
        }
        logger.error("Exception in RPC communication.  Connection: {}.  Closing connection.", (Object)this.connection.getName(), (Object)cause);
        ctx.close();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }
}

