/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.Locale;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.io.netty.channel.epoll.EpollEventLoopGroup;
import oadd.io.netty.channel.epoll.EpollServerSocketChannel;
import oadd.io.netty.channel.epoll.EpollSocketChannel;
import oadd.io.netty.channel.nio.NioEventLoopGroup;
import oadd.io.netty.channel.socket.ServerSocketChannel;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.io.netty.channel.socket.nio.NioServerSocketChannel;
import oadd.io.netty.channel.socket.nio.NioSocketChannel;
import oadd.org.apache.drill.exec.rpc.NamedThreadFactory;
import oadd.org.apache.drill.exec.util.SystemPropertyUtil;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class TransportCheck {
    static final Logger logger = LoggerFactory.getLogger(TransportCheck.class);
    private static final String USE_LINUX_EPOLL = "drill.exec.enable-epoll";
    public static final boolean SUPPORTS_EPOLL;

    public static Class<? extends ServerSocketChannel> getServerSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends SocketChannel> getClientSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static EventLoopGroup createEventLoopGroup(int nThreads, String prefix) {
        if (SUPPORTS_EPOLL) {
            return new EpollEventLoopGroup(nThreads, new NamedThreadFactory(prefix));
        }
        return new NioEventLoopGroup(nThreads, new NamedThreadFactory(prefix));
    }

    static {
        String name = SystemPropertyUtil.get("os.name").toLowerCase(Locale.US).trim();
        SUPPORTS_EPOLL = name.startsWith("linux") && SystemPropertyUtil.getBoolean(USE_LINUX_EPOLL, false);
    }
}

