/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableCollection;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public final class FastSaslServerFactory
implements SaslServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(FastSaslServerFactory.class);
    private ImmutableMap<String, List<SaslServerFactory>> serverFactories;

    public static FastSaslServerFactory getInstance() {
        return Holder.INSTANCE;
    }

    @VisibleForTesting
    static void reload() {
        FastSaslServerFactory.getInstance().refresh();
    }

    private FastSaslServerFactory() {
        this.refresh();
    }

    private void refresh() {
        Enumeration<SaslServerFactory> factories = Sasl.getSaslServerFactories();
        HashMap map = Maps.newHashMap();
        while (factories.hasMoreElements()) {
            SaslServerFactory factory = factories.nextElement();
            for (String mechanismName : factory.getMechanismNames(null)) {
                if (!map.containsKey(mechanismName)) {
                    map.put(mechanismName, new ArrayList());
                }
                ((List)map.get(mechanismName)).add(factory);
            }
        }
        this.serverFactories = ImmutableMap.copyOf(map);
        if (logger.isDebugEnabled()) {
            logger.debug("Registered sasl server factories: {}", (Object)this.serverFactories.keySet());
        }
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        List<SaslServerFactory> factories = this.serverFactories.get(mechanism);
        if (factories != null) {
            for (SaslServerFactory factory : factories) {
                SaslServer saslServer = factory.createSaslServer(mechanism, protocol, serverName, props, cbh);
                if (saslServer == null) continue;
                return saslServer;
            }
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return ((ImmutableCollection)((Object)this.serverFactories.keySet())).toArray(new String[0]);
    }

    private static final class Holder {
        static final FastSaslServerFactory INSTANCE = new FastSaslServerFactory();

        private Holder() {
        }
    }
}

