/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.Iterator;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.server.options.OptionDefinition;
import oadd.org.apache.drill.exec.server.options.OptionList;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionMetaData;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.server.options.TypeValidators;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public abstract class BaseOptionManager
implements OptionManager {
    private static final Logger logger = LoggerFactory.getLogger(BaseOptionManager.class);

    private OptionValue getOptionSafe(OptionValidator validator) {
        String optionName = validator.getOptionName();
        OptionValue value = this.getOption(optionName);
        return value == null ? this.getDefault(optionName) : value;
    }

    @Override
    public boolean getOption(TypeValidators.BooleanValidator validator) {
        return this.getOptionSafe((OptionValidator)validator).bool_val;
    }

    @Override
    public double getOption(TypeValidators.DoubleValidator validator) {
        return this.getOptionSafe((OptionValidator)validator).float_val;
    }

    @Override
    public long getOption(TypeValidators.LongValidator validator) {
        return this.getOptionSafe((OptionValidator)validator).num_val;
    }

    @Override
    public String getOption(TypeValidators.StringValidator validator) {
        return this.getOptionSafe((OptionValidator)validator).string_val;
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getByType((String)name, (OptionValue.Kind)OptionValue.Kind.BOOLEAN).bool_val;
    }

    @Override
    public long getLong(String name) {
        return this.getByType((String)name, (OptionValue.Kind)OptionValue.Kind.LONG).num_val;
    }

    @Override
    public double getDouble(String name) {
        return this.getByType((String)name, (OptionValue.Kind)OptionValue.Kind.DOUBLE).float_val;
    }

    @Override
    public String getString(String name) {
        return this.getByType((String)name, (OptionValue.Kind)OptionValue.Kind.STRING).string_val;
    }

    private OptionValue getByType(String name, OptionValue.Kind dataType) {
        OptionValue value = this.getOption(name);
        if (value == null) {
            throw UserException.systemError(null).addContext("Undefined option: " + name).build(logger);
        }
        if (value.kind != dataType) {
            throw UserException.systemError(null).addContext("Option " + name + " is of data type " + (Object)((Object)value.kind) + " but was requested as " + (Object)((Object)dataType)).build(logger);
        }
        return value;
    }

    @Override
    public OptionList getInternalOptionList() {
        return this.getAllOptionList(true);
    }

    @Override
    public OptionList getPublicOptionList() {
        return this.getAllOptionList(false);
    }

    @Override
    public void setLocalOption(String name, boolean value) {
        this.setLocalOption(name, (Object)value);
    }

    @Override
    public void setLocalOption(String name, long value) {
        this.setLocalOption(name, (Object)value);
    }

    @Override
    public void setLocalOption(String name, double value) {
        this.setLocalOption(name, (Object)value);
    }

    @Override
    public void setLocalOption(String name, String value) {
        this.setLocalOption(name, (Object)value);
    }

    @Override
    public void setLocalOption(String name, Object value) {
        OptionDefinition definition = this.getOptionDefinition(name);
        OptionValidator validator = definition.getValidator();
        OptionMetaData metaData = definition.getMetaData();
        OptionValue.AccessibleScopes type = definition.getMetaData().getAccessibleScopes();
        OptionValue.OptionScope scope = this.getScope();
        BaseOptionManager.checkOptionPermissions(name, type, scope);
        OptionValue optionValue = OptionValue.create(type, name, value, scope);
        validator.validate(optionValue, metaData, this);
        this.setLocalOptionHelper(optionValue);
    }

    @Override
    public void setLocalOption(OptionValue.Kind kind, String name, String valueStr) {
        Object value;
        switch (kind) {
            case LONG: {
                value = Long.valueOf(valueStr);
                break;
            }
            case DOUBLE: {
                value = Double.valueOf(valueStr);
                break;
            }
            case STRING: {
                value = valueStr;
                break;
            }
            case BOOLEAN: {
                value = Boolean.valueOf(valueStr);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported kind %s", new Object[]{kind}));
            }
        }
        this.setLocalOption(name, value);
    }

    private static void checkOptionPermissions(String name, OptionValue.AccessibleScopes type, OptionValue.OptionScope scope) {
        if (!type.inScopeOf(scope)) {
            throw UserException.permissionError().message(String.format("Cannot change option %s in scope %s", new Object[]{name, scope}), new Object[0]).build(logger);
        }
    }

    protected abstract void setLocalOptionHelper(OptionValue var1);

    protected abstract OptionValue.OptionScope getScope();

    private OptionList getAllOptionList(boolean internal) {
        Iterator values = this.iterator();
        OptionList optionList = new OptionList();
        while (values.hasNext()) {
            OptionValue value = (OptionValue)values.next();
            if (this.getOptionDefinition(value.getName()).getMetaData().isInternal() != internal) continue;
            optionList.add(value);
        }
        return optionList;
    }
}

