/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.io.IOException;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.core.ObjectCodec;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.JavaType;
import oadd.com.fasterxml.jackson.databind.JsonNode;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import oadd.org.apache.drill.exec.server.options.OptionDefinition;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(using=Deserializer.class)
public class PersistedOptionValue {
    public static final String SYSTEM_TYPE = "SYSTEM";
    public static final String JSON_TYPE = "type";
    public static final String JSON_KIND = "kind";
    public static final String JSON_NAME = "name";
    public static final String JSON_NUM_VAL = "num_val";
    public static final String JSON_STRING_VAL = "string_val";
    public static final String JSON_BOOL_VAL = "bool_val";
    public static final String JSON_FLOAT_VAL = "float_val";
    public static final String JSON_INTEGER_VAL = "int_val";
    private String value;
    private OptionValue.Kind kind;
    private String name;
    private Long num_val;
    private String string_val;
    private Boolean bool_val;
    private Double float_val;

    public PersistedOptionValue(String value) {
        this.value = Preconditions.checkNotNull(value);
    }

    public PersistedOptionValue(OptionValue.Kind kind, String name, Long num_val, String string_val, Boolean bool_val, Double float_val) {
        this.kind = kind;
        this.name = name;
        this.num_val = num_val;
        this.string_val = string_val;
        this.bool_val = bool_val;
        this.float_val = float_val;
        switch (kind) {
            case BOOLEAN: {
                Preconditions.checkNotNull(bool_val);
                this.value = bool_val.toString();
                break;
            }
            case STRING: {
                Preconditions.checkNotNull(string_val);
                this.value = string_val;
                break;
            }
            case DOUBLE: {
                Preconditions.checkNotNull(float_val);
                this.value = float_val.toString();
                break;
            }
            case LONG: {
                Preconditions.checkNotNull(num_val);
                this.value = num_val.toString();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported type %s", new Object[]{kind}));
            }
        }
    }

    @JsonIgnore
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="type")
    public String getType() {
        return SYSTEM_TYPE;
    }

    @JsonProperty(value="kind")
    public OptionValue.Kind getKind() {
        return this.kind;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="num_val")
    public Long getNumVal() {
        return this.num_val;
    }

    @JsonProperty(value="string_val")
    public String getStringVal() {
        return this.string_val;
    }

    @JsonProperty(value="bool_val")
    public Boolean getBoolVal() {
        return this.bool_val;
    }

    @JsonProperty(value="float_val")
    public Double getFloatVal() {
        return this.float_val;
    }

    public OptionValue toOptionValue(OptionDefinition optionDefinition, OptionValue.OptionScope optionScope) {
        Preconditions.checkNotNull(this.value, "The value must be defined in order for this to be converted to an option value");
        OptionValidator validator = optionDefinition.getValidator();
        OptionValue.Kind kind = validator.getKind();
        String name = validator.getOptionName();
        OptionValue.AccessibleScopes accessibleScopes = optionDefinition.getMetaData().getAccessibleScopes();
        return OptionValue.create(kind, accessibleScopes, name, this.value, optionScope);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistedOptionValue that = (PersistedOptionValue)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.kind != that.kind) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.num_val != null ? !this.num_val.equals(that.num_val) : that.num_val != null) {
            return false;
        }
        if (this.string_val != null ? !this.string_val.equals(that.string_val) : that.string_val != null) {
            return false;
        }
        if (this.bool_val != null ? !this.bool_val.equals(that.bool_val) : that.bool_val != null) {
            return false;
        }
        return this.float_val != null ? this.float_val.equals(that.float_val) : that.float_val == null;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.num_val != null ? this.num_val.hashCode() : 0);
        result = 31 * result + (this.string_val != null ? this.string_val.hashCode() : 0);
        result = 31 * result + (this.bool_val != null ? this.bool_val.hashCode() : 0);
        result = 31 * result + (this.float_val != null ? this.float_val.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PersistedOptionValue{value='" + this.value + '\'' + ", kind=" + (Object)((Object)this.kind) + ", name='" + this.name + '\'' + ", num_val=" + this.num_val + ", string_val='" + this.string_val + '\'' + ", bool_val=" + this.bool_val + ", float_val=" + this.float_val + '}';
    }

    public static class Deserializer
    extends StdDeserializer<PersistedOptionValue> {
        private static final Logger logger = LoggerFactory.getLogger(Deserializer.class);

        private Deserializer() {
            super(PersistedOptionValue.class);
        }

        protected Deserializer(JavaType valueType) {
            super(valueType);
        }

        protected Deserializer(StdDeserializer<?> src) {
            super(src);
        }

        @Override
        public PersistedOptionValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = p.getCodec();
            JsonNode node = (JsonNode)oc.readTree(p);
            String value = null;
            if (node.has(PersistedOptionValue.JSON_NUM_VAL)) {
                value = node.get(PersistedOptionValue.JSON_NUM_VAL).asText();
            }
            if (node.has(PersistedOptionValue.JSON_STRING_VAL)) {
                value = node.get(PersistedOptionValue.JSON_STRING_VAL).asText();
            }
            if (node.has(PersistedOptionValue.JSON_BOOL_VAL)) {
                value = node.get(PersistedOptionValue.JSON_BOOL_VAL).asText();
            }
            if (node.has(PersistedOptionValue.JSON_FLOAT_VAL)) {
                value = node.get(PersistedOptionValue.JSON_FLOAT_VAL).asText();
            }
            if (node.has(PersistedOptionValue.JSON_INTEGER_VAL)) {
                value = node.get(PersistedOptionValue.JSON_INTEGER_VAL).asText();
            }
            if (value == null) {
                logger.error("Invalid json stored {}.", (Object)new ObjectMapper().writeValueAsString(node));
            }
            return new PersistedOptionValue(value);
        }
    }
}

