/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.testing;

import oadd.com.fasterxml.jackson.annotation.JsonAutoDetect;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.org.apache.drill.common.concurrent.ExtendedLatch;
import oadd.org.apache.drill.exec.testing.CountDownLatchInjection;
import oadd.org.apache.drill.exec.testing.Injection;
import oadd.org.apache.drill.exec.testing.InjectionConfigurationException;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class CountDownLatchInjectionImpl
extends Injection
implements CountDownLatchInjection {
    private static final Logger logger = LoggerFactory.getLogger(CountDownLatchInjectionImpl.class);
    private ExtendedLatch latch = null;

    @JsonCreator
    private CountDownLatchInjectionImpl(@JsonProperty(value="address") String address, @JsonProperty(value="port") int port, @JsonProperty(value="siteClass") String siteClass, @JsonProperty(value="desc") String desc) throws InjectionConfigurationException {
        super(address, port, siteClass, desc, 0, 1, 0L);
    }

    @Override
    protected boolean injectNow() {
        return true;
    }

    @Override
    public void initialize(int count) {
        Preconditions.checkArgument(this.latch == null, "Latch can be initialized only once at %s in %s.", (Object)this.desc, (Object)this.siteClass.getSimpleName());
        Preconditions.checkArgument(count > 0, "Count has to be a positive integer at %s in %s.", (Object)this.desc, (Object)this.siteClass.getSimpleName());
        this.latch = new ExtendedLatch(count);
    }

    @Override
    public void await() throws InterruptedException {
        Preconditions.checkNotNull(this.latch, "Latch not initialized in %s at %s.", (Object)this.siteClass.getSimpleName(), (Object)this.desc);
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while awaiting in {} at {}.", (Object)this.siteClass.getSimpleName(), (Object)this.desc);
            throw e;
        }
    }

    @Override
    public void awaitUninterruptibly() {
        Preconditions.checkNotNull(this.latch, "Latch not initialized in %s at %s.", (Object)this.siteClass.getSimpleName(), (Object)this.desc);
        this.latch.awaitUninterruptibly();
    }

    @Override
    public void countDown() {
        Preconditions.checkNotNull(this.latch, "Latch not initialized in %s at %s.", (Object)this.siteClass.getSimpleName(), (Object)this.desc);
        Preconditions.checkArgument(this.latch.getCount() > 0L, "Counting down on latch more than intended.");
        this.latch.countDown();
    }

    @Override
    public void close() {
        this.latch = null;
    }
}

