/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.testing;

import java.util.concurrent.atomic.AtomicInteger;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.testing.InjectionConfigurationException;

public abstract class Injection {
    protected final String address;
    protected final int port;
    protected final Class<?> siteClass;
    protected final String desc;
    private final AtomicInteger nSkip;
    private final AtomicInteger nFire;
    private final long msPause;

    protected Injection(String address, int port, String siteClass, String desc, int nSkip, int nFire, long msPause) throws InjectionConfigurationException {
        if (desc == null || desc.isEmpty()) {
            throw new InjectionConfigurationException("Injection desc is null or empty.");
        }
        if (nSkip < 0) {
            throw new InjectionConfigurationException("Injection nSkip is not non-negative.");
        }
        if (nFire <= 0) {
            throw new InjectionConfigurationException("Injection nFire is non-positive.");
        }
        try {
            this.siteClass = Class.forName(siteClass);
        }
        catch (ClassNotFoundException e) {
            throw new InjectionConfigurationException("Injection siteClass not found.", e);
        }
        this.address = address;
        this.port = port;
        this.desc = desc;
        this.nSkip = new AtomicInteger(nSkip);
        this.nFire = new AtomicInteger(nFire);
        this.msPause = msPause;
    }

    protected boolean injectNow() {
        return this.nSkip.decrementAndGet() < 0 && this.nFire.decrementAndGet() >= 0;
    }

    public String getDesc() {
        return this.desc;
    }

    public Class<?> getSiteClass() {
        return this.siteClass;
    }

    public final boolean isValidForBit(CoordinationProtos.DrillbitEndpoint endpoint) {
        return this.address == null || this.address.equals(endpoint.getAddress()) && this.port == endpoint.getUserPort();
    }

    public long getMsPause() {
        return this.msPause;
    }
}

