/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public enum ActionOnFile {
    NONE{

        @Override
        public void action(URL url) {
        }
    }
    ,
    RENAME{

        @Override
        public void action(URL url) {
            String fileName = url.getFile();
            File file = new File(url.getPath());
            String currentDateTime = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String newFileName = new StringBuilder(fileName).insert(fileName.lastIndexOf("."), "-" + currentDateTime).toString();
            Path filePath = file.toPath();
            try {
                Files.move(filePath, filePath.resolveSibling(newFileName), new CopyOption[0]);
            }
            catch (IOException e) {
                logger.error("There was an error during file {} rename.", (Object)fileName, (Object)e);
            }
        }
    }
    ,
    REMOVE{

        @Override
        public void action(URL url) {
            File file = new File(url.getPath());
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.error("There was an error during file {} removing.", (Object)url.getFile(), (Object)e);
            }
        }
    };

    private static final Logger logger;

    public abstract void action(URL var1);

    static {
        logger = LoggerFactory.getLogger(ActionOnFile.class);
    }
}

