/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.function.BiFunction;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.util.DrillStringUtils;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class ValueVectorElementFormatter {
    private static final Logger logger = LoggerFactory.getLogger(ValueVectorElementFormatter.class);
    private final OptionManager options;
    private DateTimeFormatter timestampFormatter;
    private DateTimeFormatter dateFormatter;
    private DateTimeFormatter timeFormatter;

    public ValueVectorElementFormatter(OptionManager options) {
        this.options = options;
    }

    public String format(Object value, TypeProtos.MinorType minorType) {
        switch (minorType) {
            case TIMESTAMP: {
                if (value instanceof LocalDateTime) {
                    return this.format((LocalDateTime)value, this.options.getString("web.display_format.timestamp"), (v, p) -> v.format(this.getTimestampFormatter((String)p)));
                }
            }
            case DATE: {
                if (value instanceof LocalDate) {
                    return this.format((LocalDate)value, this.options.getString("web.display_format.date"), (v, p) -> v.format(this.getDateFormatter((String)p)));
                }
            }
            case TIME: {
                if (value instanceof LocalTime) {
                    return this.format((LocalTime)value, this.options.getString("web.display_format.time"), (v, p) -> v.format(this.getTimeFormatter((String)p)));
                }
            }
            case VARBINARY: {
                if (!(value instanceof byte[])) break;
                byte[] bytes = (byte[])value;
                return DrillStringUtils.toBinaryString(bytes);
            }
        }
        return value.toString();
    }

    private <T> String format(T value, String formatPattern, BiFunction<T, String, String> formatFunction) {
        if (formatPattern.isEmpty()) {
            return value.toString();
        }
        String formattedValue = null;
        try {
            formattedValue = formatFunction.apply(value, formatPattern);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not format the value '%s' with the pattern '%s': %s", value, formatPattern, e.getMessage()));
        }
        return formattedValue;
    }

    private DateTimeFormatter getTimestampFormatter(String formatPattern) {
        if (this.timestampFormatter == null) {
            this.timestampFormatter = DateTimeFormatter.ofPattern(formatPattern);
        }
        return this.timestampFormatter;
    }

    private DateTimeFormatter getDateFormatter(String formatPattern) {
        if (this.dateFormatter == null) {
            this.dateFormatter = DateTimeFormatter.ofPattern(formatPattern);
        }
        return this.dateFormatter;
    }

    private DateTimeFormatter getTimeFormatter(String formatPattern) {
        if (this.timeFormatter == null) {
            this.timeFormatter = DateTimeFormatter.ofPattern(formatPattern);
        }
        return this.timeFormatter;
    }
}

