/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VariableWidthVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedVariableWidthVectorLike;

public class AllocationHelper {
    public static final int STD_REPETITION_FACTOR = 5;

    public static void allocate(ValueVector vector, int valueCount, int bytesPerValue) {
        AllocationHelper.allocate(vector, valueCount, bytesPerValue, 5);
    }

    public static void allocatePrecomputedChildCount(ValueVector vector, int valueCount, int bytesPerValue, int childValCount) {
        childValCount = Math.max(1, childValCount);
        valueCount = Math.max(1, valueCount);
        bytesPerValue = Math.max(1, bytesPerValue);
        if (vector instanceof FixedWidthVector) {
            ((FixedWidthVector)vector).allocateNew(valueCount);
        } else if (vector instanceof VariableWidthVector) {
            ((VariableWidthVector)vector).allocateNew(valueCount * bytesPerValue, valueCount);
        } else if (vector instanceof RepeatedFixedWidthVectorLike) {
            ((RepeatedFixedWidthVectorLike)((Object)vector)).allocateNew(valueCount, childValCount);
        } else if (vector instanceof RepeatedVariableWidthVectorLike) {
            ((RepeatedVariableWidthVectorLike)((Object)vector)).allocateNew(childValCount * bytesPerValue, valueCount, childValCount);
        } else {
            vector.allocateNew();
        }
    }

    public static void allocate(ValueVector vector, int valueCount, int bytesPerValue, int repeatedPerTop) {
        AllocationHelper.allocatePrecomputedChildCount(vector, valueCount, bytesPerValue, repeatedPerTop * valueCount);
    }

    public static void allocate(ValueVector vector, int valueCount, int bytesPerValue, float repeatedPerTop) {
        AllocationHelper.allocatePrecomputedChildCount(vector, valueCount, bytesPerValue, (int)Math.ceil(repeatedPerTop * (float)valueCount));
    }

    public static void allocateNew(ValueVector vector, int valueCount) {
        if (vector instanceof FixedWidthVector) {
            ((FixedWidthVector)vector).allocateNew(valueCount);
        } else {
            vector.allocateNew();
        }
    }
}

