/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.io.InputStream;
import java.io.InputStreamReader;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.Var16CharHolder;
import oadd.org.apache.drill.exec.vector.Var16CharVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;

public class Var16CharAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.VAR16CHAR);
    private final Var16CharVector.Accessor ac;

    public Var16CharAccessor(Var16CharVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public Class<?> getObjectClass() {
        return String.class;
    }

    @Override
    public Object getObject(int index) {
        return this.ac.getObject(index);
    }

    @Override
    public InputStream getStream(int index) {
        Var16CharHolder h = new Var16CharHolder();
        this.ac.get(index, h);
        return new ByteBufInputStream(h.buffer.slice(h.start, h.end));
    }

    @Override
    public byte[] getBytes(int index) {
        return this.ac.get(index);
    }

    @Override
    public InputStreamReader getReader(int index) {
        return new InputStreamReader(this.getStream(index), Charsets.UTF_16);
    }

    @Override
    public String getString(int index) {
        return new String(this.getBytes(index), Charsets.UTF_16);
    }
}

