/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.reader;

import java.util.ArrayList;
import oadd.org.apache.drill.exec.vector.accessor.ArrayReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import oadd.org.apache.drill.exec.vector.accessor.ObjectReader;
import oadd.org.apache.drill.exec.vector.accessor.ObjectType;
import oadd.org.apache.drill.exec.vector.accessor.ScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.TupleReader;
import oadd.org.apache.drill.exec.vector.accessor.VariantReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.NullStateReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.ReaderEvents;

public abstract class AbstractTupleReader
implements TupleReader,
ReaderEvents {
    private final AbstractObjectReader[] readers;
    protected NullStateReader nullStateReader;

    protected AbstractTupleReader(AbstractObjectReader[] readers) {
        this.readers = readers;
    }

    @Override
    public ObjectType type() {
        return ObjectType.TUPLE;
    }

    @Override
    public void bindIndex(ColumnReaderIndex index) {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].events().bindIndex(index);
        }
    }

    @Override
    public void bindNullState(NullStateReader nullStateReader) {
        this.nullStateReader = nullStateReader;
    }

    @Override
    public NullStateReader nullStateReader() {
        return this.nullStateReader;
    }

    @Override
    public boolean isNull() {
        return this.nullStateReader.isNull();
    }

    @Override
    public int columnCount() {
        return this.tupleSchema().size();
    }

    @Override
    public ObjectReader column(int colIndex) {
        return this.readers[colIndex];
    }

    @Override
    public ObjectReader column(String colName) {
        int index = this.tupleSchema().index(colName);
        if (index == -1) {
            return null;
        }
        return this.readers[index];
    }

    @Override
    public ObjectType type(int colIndex) {
        return this.column(colIndex).type();
    }

    @Override
    public ObjectType type(String colName) {
        return this.column(colName).type();
    }

    @Override
    public ScalarReader scalar(int colIndex) {
        return this.column(colIndex).scalar();
    }

    @Override
    public ScalarReader scalar(String colName) {
        return this.column(colName).scalar();
    }

    @Override
    public TupleReader tuple(int colIndex) {
        return this.column(colIndex).tuple();
    }

    @Override
    public TupleReader tuple(String colName) {
        return this.column(colName).tuple();
    }

    @Override
    public ArrayReader array(int colIndex) {
        return this.column(colIndex).array();
    }

    @Override
    public ArrayReader array(String colName) {
        return this.column(colName).array();
    }

    @Override
    public VariantReader variant(int colIndex) {
        return this.column(colIndex).variant();
    }

    @Override
    public VariantReader variant(String colName) {
        return this.column(colName).variant();
    }

    @Override
    public void reposition() {
        for (int i = 0; i < this.columnCount(); ++i) {
            this.readers[i].events().reposition();
        }
    }

    @Override
    public Object getObject() {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < this.columnCount(); ++i) {
            elements.add(this.readers[i].getObject());
        }
        return elements;
    }

    @Override
    public String getAsString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        for (int i = 0; i < this.columnCount(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.readers[i].getAsString());
        }
        buf.append("}");
        return buf.toString();
    }

    public static class TupleObjectReader
    extends AbstractObjectReader {
        private final AbstractTupleReader tupleReader;

        public TupleObjectReader(AbstractTupleReader tupleReader) {
            this.tupleReader = tupleReader;
        }

        @Override
        public TupleReader tuple() {
            return this.tupleReader;
        }

        @Override
        public Object getObject() {
            return this.tupleReader.getObject();
        }

        @Override
        public String getAsString() {
            return this.tupleReader.getAsString();
        }

        @Override
        public ReaderEvents events() {
            return this.tupleReader;
        }

        @Override
        public ColumnReader reader() {
            return this.tupleReader;
        }
    }
}

