/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.reader;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.vector.accessor.ColumnAccessors;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import oadd.org.apache.drill.exec.vector.accessor.reader.NullStateReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessors;

public class NullStateReaders {
    public static final RequiredStateReader REQUIRED_STATE_READER = new RequiredStateReader();

    private NullStateReaders() {
    }

    protected static class TypeVectorStateReader
    implements NullStateReader {
        public final ColumnAccessors.UInt1ColumnReader typeReader;

        public TypeVectorStateReader(ColumnAccessors.UInt1ColumnReader typeReader) {
            this.typeReader = typeReader;
        }

        @Override
        public void bindIndex(ColumnReaderIndex rowIndex) {
            this.typeReader.bindIndex(rowIndex);
        }

        @Override
        public boolean isNull() {
            return this.typeReader.getInt() == 0;
        }
    }

    protected static class ComplexMemberStateReader
    implements NullStateReader {
        private ColumnAccessors.UInt1ColumnReader typeReader;
        private TypeProtos.MinorType type;

        public ComplexMemberStateReader(ColumnAccessors.UInt1ColumnReader typeReader, TypeProtos.MinorType type) {
            this.typeReader = typeReader;
            this.type = type;
        }

        @Override
        public void bindIndex(ColumnReaderIndex rowIndex) {
        }

        @Override
        public boolean isNull() {
            return this.typeReader.getInt() != this.type.getNumber();
        }
    }

    protected static class MemberNullStateReader
    implements NullStateReader {
        private final NullStateReader unionNullState;
        private final NullStateReader memberNullState;

        public MemberNullStateReader(NullStateReader unionNullState, NullStateReader memberNullState) {
            this.unionNullState = unionNullState;
            this.memberNullState = memberNullState;
        }

        @Override
        public void bindIndex(ColumnReaderIndex rowIndex) {
            this.memberNullState.bindIndex(rowIndex);
        }

        @Override
        public boolean isNull() {
            return this.unionNullState.isNull() || this.memberNullState.isNull();
        }
    }

    protected static class ListIsSetVectorStateReader
    implements NullStateReader {
        private final VectorAccessor bitsAccessor;
        private final ColumnAccessors.UInt1ColumnReader isSetReader;

        public ListIsSetVectorStateReader(VectorAccessor bitsAccessor) {
            this.bitsAccessor = bitsAccessor;
            this.isSetReader = new ColumnAccessors.UInt1ColumnReader();
            this.isSetReader.bindVector(null, bitsAccessor);
            this.isSetReader.bindNullState(REQUIRED_STATE_READER);
        }

        @Override
        public void bindIndex(ColumnReaderIndex rowIndex) {
            this.bitsAccessor.bind(rowIndex);
            this.isSetReader.bindIndex(rowIndex);
        }

        @Override
        public boolean isNull() {
            return this.isSetReader.getInt() == 0;
        }
    }

    protected static class NullableIsSetVectorStateReader
    implements NullStateReader {
        private final VectorAccessor nullableAccessor;
        private final ColumnAccessors.UInt1ColumnReader isSetReader;

        public NullableIsSetVectorStateReader(VectorAccessor nullableAccessor) {
            this.nullableAccessor = nullableAccessor;
            this.isSetReader = new ColumnAccessors.UInt1ColumnReader();
            this.isSetReader.bindVector(null, VectorAccessors.nullableBitsAccessor(nullableAccessor));
            this.isSetReader.bindNullState(REQUIRED_STATE_READER);
        }

        @Override
        public void bindIndex(ColumnReaderIndex rowIndex) {
            this.nullableAccessor.bind(rowIndex);
            this.isSetReader.bindIndex(rowIndex);
        }

        @Override
        public boolean isNull() {
            return this.isSetReader.getInt() == 0;
        }
    }

    protected static class RequiredStateReader
    implements NullStateReader {
        protected RequiredStateReader() {
        }

        @Override
        public void bindIndex(ColumnReaderIndex rowIndex) {
        }

        @Override
        public boolean isNull() {
            return false;
        }
    }
}

