/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.reader;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ValueType;
import oadd.org.apache.drill.exec.vector.accessor.reader.BaseScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.NullStateReaders;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessor;

public class OffsetVectorReader
extends BaseScalarReader.BaseFixedWidthReader {
    private static final int VALUE_WIDTH = 4;

    public OffsetVectorReader(VectorAccessor offsetsAccessor) {
        this.vectorAccessor = offsetsAccessor;
        this.bufferAccessor = this.bufferAccessor(offsetsAccessor);
        this.nullStateReader = NullStateReaders.REQUIRED_STATE_READER;
    }

    @Override
    public ValueType valueType() {
        return ValueType.INTEGER;
    }

    @Override
    public int width() {
        return 4;
    }

    public long getEntry() {
        DrillBuf buf = this.bufferAccessor.buffer();
        int readOffset = this.vectorIndex.offset() * 4;
        long start = buf.getInt(readOffset);
        long end = buf.getInt(readOffset + 4);
        return (start << 32) + (end - start);
    }

    @Override
    public void reposition() {
    }

    @Override
    public ColumnMetadata schema() {
        return null;
    }
}

