/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.math.BigDecimal;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.VariantMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriter;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.ObjectType;
import oadd.org.apache.drill.exec.vector.accessor.ObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.TupleWriter;
import oadd.org.apache.drill.exec.vector.accessor.VariantWriter;
import oadd.org.apache.drill.exec.vector.accessor.WriterPosition;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.UnionVectorShim;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import oadd.org.apache.drill.exec.vector.complex.UnionVector;
import oadd.org.joda.time.Period;

public class UnionWriterImpl
implements VariantWriter,
WriterEvents {
    private final ColumnMetadata schema;
    private UnionShim shim;
    private ColumnWriterIndex index;
    private WriterEvents.State state = WriterEvents.State.IDLE;
    private VariantWriter.VariantWriterListener listener;
    private final WriterPosition elementPosition = new ElementPositions();

    public UnionWriterImpl(ColumnMetadata schema) {
        this.schema = schema;
    }

    public UnionWriterImpl(ColumnMetadata schema, UnionVector vector, AbstractObjectWriter[] variants) {
        this(schema);
        this.bindShim(new UnionVectorShim(vector, variants));
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.index = index;
        this.shim.bindIndex(index);
    }

    public void bindListener(VariantWriter.VariantWriterListener listener) {
        this.listener = listener;
    }

    @Override
    public void bindListener(WriterEvents.ColumnWriterListener listener) {
    }

    public WriterEvents.State state() {
        return this.state;
    }

    public ColumnWriterIndex index() {
        return this.index;
    }

    public VariantWriter.VariantWriterListener listener() {
        return this.listener;
    }

    public UnionShim shim() {
        return this.shim;
    }

    public WriterPosition elementPosition() {
        return this.elementPosition;
    }

    public void bindShim(UnionShim shim) {
        this.shim = shim;
        shim.bindWriter(this);
        if (this.state != WriterEvents.State.IDLE) {
            shim.startWrite();
            if (this.state == WriterEvents.State.IN_ROW) {
                shim.startRow();
            }
        }
    }

    @Override
    public ObjectType type() {
        return ObjectType.VARIANT;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    @Override
    public VariantMetadata variantSchema() {
        return this.schema.variantSchema();
    }

    @Override
    public int size() {
        return this.variantSchema().size();
    }

    @Override
    public boolean hasType(TypeProtos.MinorType type) {
        return this.shim.hasType(type);
    }

    @Override
    public void setNull() {
        this.shim.setNull();
    }

    @Override
    public ObjectWriter memberWriter(TypeProtos.MinorType type) {
        return this.shim.member(type);
    }

    @Override
    public ObjectWriter member(TypeProtos.MinorType type) {
        ObjectWriter writer = this.shim.member(type);
        this.setType(type);
        return writer;
    }

    @Override
    public void setType(TypeProtos.MinorType type) {
        this.shim.setType(type);
    }

    @Override
    public ObjectWriter addMember(ColumnMetadata colSchema) {
        return this.shim.addMember(colSchema);
    }

    @Override
    public ObjectWriter addMember(TypeProtos.MinorType type) {
        return this.shim.addMember(type);
    }

    protected void addMember(AbstractObjectWriter writer) {
        TypeProtos.MinorType type = writer.schema().type();
        if (!this.variantSchema().hasType(type)) {
            this.variantSchema().addType(writer.schema());
        }
        writer.events().bindIndex(this.index);
        if (this.state != WriterEvents.State.IDLE) {
            writer.events().startWrite();
            if (this.state == WriterEvents.State.IN_ROW) {
                writer.events().startRow();
            }
        }
    }

    @Override
    public ScalarWriter scalar(TypeProtos.MinorType type) {
        return this.member(type).scalar();
    }

    @Override
    public TupleWriter tuple() {
        return this.member(TypeProtos.MinorType.MAP).tuple();
    }

    @Override
    public ArrayWriter array() {
        return this.member(TypeProtos.MinorType.LIST).array();
    }

    @Override
    public void startWrite() {
        assert (this.state == WriterEvents.State.IDLE);
        this.state = WriterEvents.State.IN_WRITE;
        this.shim.startWrite();
    }

    @Override
    public void startRow() {
        assert (this.state == WriterEvents.State.IN_WRITE);
        this.state = WriterEvents.State.IN_ROW;
        this.shim.startRow();
    }

    @Override
    public void endArrayValue() {
        this.shim.endArrayValue();
    }

    @Override
    public void restartRow() {
        assert (this.state == WriterEvents.State.IN_ROW);
        this.shim.restartRow();
    }

    @Override
    public void saveRow() {
        assert (this.state == WriterEvents.State.IN_ROW);
        this.shim.saveRow();
        this.state = WriterEvents.State.IN_WRITE;
    }

    @Override
    public void preRollover() {
        assert (this.state == WriterEvents.State.IN_ROW);
        this.shim.preRollover();
    }

    @Override
    public void postRollover() {
        assert (this.state == WriterEvents.State.IN_ROW);
        this.shim.postRollover();
    }

    @Override
    public void endWrite() {
        assert (this.state != WriterEvents.State.IDLE);
        this.shim.endWrite();
        this.state = WriterEvents.State.IDLE;
    }

    @Override
    public int lastWriteIndex() {
        return this.shim.lastWriteIndex();
    }

    @Override
    public int rowStartIndex() {
        return this.shim.rowStartIndex();
    }

    @Override
    public int writeIndex() {
        return this.index.vectorIndex();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(Object value) {
        if (value == null) {
            this.setNull();
            return;
        } else if (value instanceof Integer) {
            this.scalar(TypeProtos.MinorType.INT).setInt((Integer)value);
            return;
        } else if (value instanceof Long) {
            this.scalar(TypeProtos.MinorType.BIGINT).setLong((Long)value);
            return;
        } else if (value instanceof String) {
            this.scalar(TypeProtos.MinorType.VARCHAR).setString((String)value);
            return;
        } else {
            if (value instanceof BigDecimal) {
                throw new IllegalArgumentException("Decimal is ambiguous, please use scalar(type)");
            }
            if (value instanceof Period) {
                throw new IllegalArgumentException("Period is ambiguous, please use scalar(type)");
            }
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                this.scalar(TypeProtos.MinorType.VARBINARY).setBytes(bytes, bytes.length);
                return;
            } else if (value instanceof Byte) {
                this.scalar(TypeProtos.MinorType.TINYINT).setInt(((Byte)value).byteValue());
                return;
            } else if (value instanceof Short) {
                this.scalar(TypeProtos.MinorType.SMALLINT).setInt(((Short)value).shortValue());
                return;
            } else if (value instanceof Double) {
                this.scalar(TypeProtos.MinorType.FLOAT8).setDouble((Double)value);
                return;
            } else if (value instanceof Float) {
                this.scalar(TypeProtos.MinorType.FLOAT4).setDouble(((Float)value).floatValue());
                return;
            } else {
                if (!(value instanceof Object[])) throw new IllegalArgumentException("Unsupported type " + value.getClass().getSimpleName());
                if (this.hasType(TypeProtos.MinorType.MAP) && this.hasType(TypeProtos.MinorType.LIST)) {
                    throw new UnsupportedOperationException("Union has both a map and a list, so Object[] is ambiguous");
                }
                if (this.hasType(TypeProtos.MinorType.MAP)) {
                    this.tuple().setObject(value);
                    return;
                } else {
                    if (!this.hasType(TypeProtos.MinorType.LIST)) throw new IllegalArgumentException("Unsupported type " + value.getClass().getSimpleName());
                    this.array().setObject(value);
                }
            }
        }
    }

    @Override
    public void dump(HierarchicalFormatter format) {
    }

    private class ElementPositions
    implements WriterPosition {
        private ElementPositions() {
        }

        @Override
        public int rowStartIndex() {
            return UnionWriterImpl.this.shim.rowStartIndex();
        }

        @Override
        public int lastWriteIndex() {
            return UnionWriterImpl.this.shim.lastWriteIndex();
        }

        @Override
        public int writeIndex() {
            return UnionWriterImpl.this.index.vectorIndex();
        }
    }

    public static class VariantObjectWriter
    extends AbstractObjectWriter {
        private final UnionWriterImpl writer;

        public VariantObjectWriter(UnionWriterImpl writer) {
            this.writer = writer;
        }

        @Override
        public ColumnWriter writer() {
            return this.writer;
        }

        @Override
        public VariantWriter variant() {
            return this.writer;
        }

        @Override
        public WriterEvents events() {
            return this.writer;
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            this.writer.dump(format);
        }
    }

    public static interface UnionShim
    extends WriterEvents {
        public void bindWriter(UnionWriterImpl var1);

        public void setNull();

        public boolean hasType(TypeProtos.MinorType var1);

        public ObjectWriter member(TypeProtos.MinorType var1);

        public void setType(TypeProtos.MinorType var1);

        @Override
        public int lastWriteIndex();

        @Override
        public int rowStartIndex();

        public AbstractObjectWriter addMember(ColumnMetadata var1);

        public AbstractObjectWriter addMember(TypeProtos.MinorType var1);

        public void addMember(AbstractObjectWriter var1);
    }
}

