/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class JsonReaderUtils {
    public static void ensureAtLeastOneField(BaseWriter.ComplexWriter writer, Collection<SchemaPath> columns, boolean allTextMode, List<BaseWriter.ListWriter> emptyArrayWriters) {
        PathSegment fieldPath;
        ArrayList<BaseWriter.MapWriter> writerList = Lists.newArrayList();
        ArrayList<PathSegment> fieldPathList = Lists.newArrayList();
        BitSet emptyStatus = new BitSet(columns.size());
        int i = 0;
        for (SchemaPath sp : columns) {
            fieldPath = sp.getRootSegment();
            BaseWriter.MapWriter fieldWriter = writer.rootAsMap();
            while (fieldPath.getChild() != null && !fieldPath.getChild().isArray()) {
                fieldWriter = fieldWriter.map(fieldPath.getNameSegment().getPath());
                fieldPath = fieldPath.getChild();
            }
            writerList.add(fieldWriter);
            fieldPathList.add(fieldPath);
            if (fieldWriter.isEmptyMap()) {
                emptyStatus.set(i, true);
            }
            if (i == 0 && !allTextMode) break;
            ++i;
        }
        for (int j = 0; j < fieldPathList.size(); ++j) {
            BaseWriter.MapWriter fieldWriter = (BaseWriter.MapWriter)writerList.get(j);
            fieldPath = (PathSegment)fieldPathList.get(j);
            if (!emptyStatus.get(j)) continue;
            if (allTextMode) {
                fieldWriter.varChar(fieldPath.getNameSegment().getPath());
                continue;
            }
            fieldWriter.integer(fieldPath.getNameSegment().getPath());
        }
        for (BaseWriter.ListWriter field : emptyArrayWriters) {
            if (field.getValueCapacity() != 0) continue;
            if (allTextMode) {
                field.varChar();
                continue;
            }
            field.integer();
        }
    }
}

