/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.NullableDecimal28DenseVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class NullableDecimal28DenseWriterImpl
extends AbstractFieldWriter {
    private final NullableDecimal28DenseVector.Mutator mutator;
    final NullableDecimal28DenseVector vector;

    public NullableDecimal28DenseWriterImpl(NullableDecimal28DenseVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(Decimal28DenseHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableDecimal28DenseHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.mutator.setNull(this.idx());
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDecimal28Dense(int start, DrillBuf buffer, int scale, int precision) {
        this.mutator.setSafe(this.idx(), 1, start, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

