/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.util.ArrayList;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedIntervalYearHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.joda.time.Period;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RepeatedIntervalYearHolderReaderImpl
extends AbstractFieldReader {
    private NullableIntervalYearHolder holder = new NullableIntervalYearHolder();
    private int index = -1;
    private RepeatedIntervalYearHolder repeatedHolder;

    public RepeatedIntervalYearHolderReaderImpl(RepeatedIntervalYearHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedIntervalYearHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public Period readPeriod(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        Period value = this.readPeriod();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public Period readPeriod() {
        if (!this.isSet()) {
            return null;
        }
        Period value = new Period(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        ArrayList<Period> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Period value = new Period(this.holder.value);
        return value;
    }
}

