/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.util.Iterator;
import java.util.Map;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.RepeatedMapHolder;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedMapVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedMapWriter;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleLikeRepeatedMapReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class RepeatedMapReaderImpl
extends AbstractFieldReader {
    private static final int NO_VALUES = 0x7FFFFFFE;
    private final RepeatedMapVector vector;
    private final Map<String, FieldReader> fields = Maps.newHashMap();
    private int currentOffset;
    private int maxOffset;

    public RepeatedMapReaderImpl(RepeatedMapVector vector) {
        this.vector = vector;
    }

    @Override
    public FieldReader reader(String name) {
        FieldReader reader = this.fields.get(name);
        if (reader == null) {
            ValueVector child = this.vector.getChild(name);
            reader = child == null ? NullReader.INSTANCE : child.getReader();
            this.fields.put(name, reader);
            reader.setPosition(this.currentOffset);
        }
        return reader;
    }

    @Override
    public FieldReader reader() {
        if (this.isNull()) {
            return NullReader.INSTANCE;
        }
        this.setChildrenPosition(this.currentOffset);
        return new SingleLikeRepeatedMapReaderImpl(this.vector, this);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentOffset = 0;
        this.maxOffset = 0;
        for (FieldReader reader : this.fields.values()) {
            reader.reset();
        }
        this.fields.clear();
    }

    @Override
    public int size() {
        return this.isNull() ? 0 : this.maxOffset - this.currentOffset;
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index == 0x7FFFFFFE) {
            this.currentOffset = 0x7FFFFFFE;
            return;
        }
        super.setPosition(index);
        RepeatedMapHolder h = new RepeatedMapHolder();
        this.vector.getAccessor().get(index, h);
        if (h.start == h.end) {
            this.currentOffset = 0x7FFFFFFE;
        } else {
            this.currentOffset = h.start - 1;
            this.maxOffset = h.end - 1;
            this.setChildrenPosition(this.currentOffset);
        }
    }

    public void setSinglePosition(int index, int childIndex) {
        super.setPosition(index);
        RepeatedMapHolder h = new RepeatedMapHolder();
        this.vector.getAccessor().get(index, h);
        if (h.start == h.end) {
            this.currentOffset = 0x7FFFFFFE;
        } else {
            int singleOffset = h.start + childIndex;
            assert (singleOffset < h.end);
            this.currentOffset = singleOffset;
            this.maxOffset = singleOffset + 1;
            this.setChildrenPosition(singleOffset);
        }
    }

    @Override
    public boolean next() {
        if (this.currentOffset < this.maxOffset) {
            this.setChildrenPosition(++this.currentOffset);
            return true;
        }
        this.currentOffset = 0x7FFFFFFE;
        return false;
    }

    public boolean isNull() {
        return this.currentOffset == 0x7FFFFFFE;
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public Iterator<String> iterator() {
        return this.vector.fieldNameIterator();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(BaseWriter.MapWriter writer) {
        if (this.isNull()) {
            return;
        }
        RepeatedMapWriter impl = (RepeatedMapWriter)writer;
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    public void copyAsValueSingle(BaseWriter.MapWriter writer) {
        if (this.isNull()) {
            return;
        }
        SingleMapWriter impl = (SingleMapWriter)writer;
        impl.container.copyFromSafe(this.currentOffset, impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        if (this.isNull()) {
            return;
        }
        RepeatedMapWriter impl = (RepeatedMapWriter)writer.map(name);
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    private void setChildrenPosition(int index) {
        for (FieldReader r : this.fields.values()) {
            r.setPosition(index);
        }
    }
}

