/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.metastore;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.SchemaPathUtils;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.metastore.ColumnStatistics;
import oadd.org.apache.drill.metastore.StatisticsKind;
import oadd.org.apache.drill.metastore.TableMetadata;
import oadd.org.apache.hadoop.fs.Path;

public class FileTableMetadata
implements TableMetadata {
    private final String tableName;
    private final Path location;
    private final TupleMetadata schema;
    private final Map<SchemaPath, ColumnStatistics> columnsStatistics;
    private final Map<String, Object> tableStatistics;
    private final Map<String, StatisticsKind> statisticsKinds;
    private final long lastModifiedTime;
    private final String owner;
    private final Set<String> partitionKeys;

    public FileTableMetadata(String tableName, Path location, TupleMetadata schema, Map<SchemaPath, ColumnStatistics> columnsStatistics, Map<StatisticsKind, Object> tableStatistics, long lastModifiedTime, String owner, Set<String> partitionKeys) {
        this.tableName = tableName;
        this.location = location;
        this.schema = schema;
        this.columnsStatistics = columnsStatistics;
        this.tableStatistics = new HashMap<String, Object>();
        this.statisticsKinds = new HashMap<String, StatisticsKind>();
        tableStatistics.forEach((statisticsKind, value) -> {
            this.tableStatistics.put(statisticsKind.getName(), value);
            this.statisticsKinds.put(statisticsKind.getName(), (StatisticsKind)statisticsKind);
        });
        this.lastModifiedTime = lastModifiedTime;
        this.owner = owner;
        this.partitionKeys = partitionKeys;
    }

    @Override
    public Object getStatisticsForColumn(SchemaPath columnName, StatisticsKind statisticsKind) {
        return this.columnsStatistics.get(columnName).getStatistic(statisticsKind);
    }

    @Override
    public ColumnStatistics getColumnStatistics(SchemaPath columnName) {
        return this.columnsStatistics.get(columnName);
    }

    @Override
    public Object getStatistic(StatisticsKind statisticsKind) {
        return this.tableStatistics.get(statisticsKind.getName());
    }

    @Override
    public boolean containsExactStatistics(StatisticsKind statisticsKind) {
        return this.statisticsKinds.get(statisticsKind.getName()).isExact();
    }

    @Override
    public ColumnMetadata getColumn(SchemaPath name) {
        return SchemaPathUtils.getColumnMetadata(name, this.schema);
    }

    @Override
    public TupleMetadata getSchema() {
        return this.schema;
    }

    public boolean isPartitionColumn(String fieldName) {
        return this.partitionKeys.contains(fieldName);
    }

    boolean isPartitioned() {
        return !this.partitionKeys.isEmpty();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Path getLocation() {
        return this.location;
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Map<SchemaPath, ColumnStatistics> getColumnsStatistics() {
        return this.columnsStatistics;
    }

    @Override
    public FileTableMetadata cloneWithStats(Map<SchemaPath, ColumnStatistics> columnStatistics, Map<StatisticsKind, Object> tableStatistics) {
        HashMap<StatisticsKind, Object> mergedTableStatistics = new HashMap<StatisticsKind, Object>();
        this.tableStatistics.forEach((statisticsName, value) -> {
            StatisticsKind statisticsKind = this.statisticsKinds.get(statisticsName);
            Object statisticsValue = this.tableStatistics.get(statisticsName);
            mergedTableStatistics.put(statisticsKind, statisticsValue);
        });
        tableStatistics.forEach((statisticsKind, statisticsValue) -> {
            if (statisticsValue != null && (statisticsKind.isExact() || !this.statisticsKinds.get(statisticsKind.getName()).isExact())) {
                mergedTableStatistics.put((StatisticsKind)statisticsKind, statisticsValue);
            }
        });
        HashMap<SchemaPath, ColumnStatistics> newColumnsStatistics = new HashMap<SchemaPath, ColumnStatistics>(this.columnsStatistics);
        for (Map.Entry<SchemaPath, ColumnStatistics> columnStatisticEntry : this.columnsStatistics.entrySet()) {
            SchemaPath columnName = columnStatisticEntry.getKey();
            newColumnsStatistics.put(columnName, columnStatisticEntry.getValue().cloneWithStats(columnStatistics.get(columnName)));
        }
        return new FileTableMetadata(this.tableName, this.location, this.schema, newColumnsStatistics, mergedTableStatistics, this.lastModifiedTime, this.owner, this.partitionKeys);
    }
}

