/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.metastore;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.SchemaPathUtils;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.metastore.BaseMetadata;
import oadd.org.apache.drill.metastore.ColumnStatistics;
import oadd.org.apache.drill.metastore.StatisticsKind;
import oadd.org.apache.hadoop.fs.Path;

public class PartitionMetadata
implements BaseMetadata {
    private final SchemaPath column;
    private final TupleMetadata schema;
    private final Map<SchemaPath, ColumnStatistics> columnsStatistics;
    private final Map<String, Object> partitionStatistics;
    private final Map<String, StatisticsKind> statisticsKinds;
    private final Set<Path> location;
    private final String tableName;
    private final long lastModifiedTime;

    public PartitionMetadata(SchemaPath column, TupleMetadata schema, Map<SchemaPath, ColumnStatistics> columnsStatistics, Map<StatisticsKind, Object> partitionStatistics, Set<Path> location, String tableName, long lastModifiedTime) {
        this.column = column;
        this.schema = schema;
        this.columnsStatistics = columnsStatistics;
        this.partitionStatistics = new HashMap<String, Object>();
        this.statisticsKinds = new HashMap<String, StatisticsKind>();
        partitionStatistics.forEach((statisticsKind, value) -> {
            this.partitionStatistics.put(statisticsKind.getName(), value);
            this.statisticsKinds.put(statisticsKind.getName(), (StatisticsKind)statisticsKind);
        });
        this.location = location;
        this.tableName = tableName;
        this.lastModifiedTime = lastModifiedTime;
    }

    @Override
    public ColumnMetadata getColumn(SchemaPath name) {
        return SchemaPathUtils.getColumnMetadata(name, this.schema);
    }

    @Override
    public TupleMetadata getSchema() {
        return this.schema;
    }

    @Override
    public Map<SchemaPath, ColumnStatistics> getColumnsStatistics() {
        return this.columnsStatistics;
    }

    @Override
    public ColumnStatistics getColumnStatistics(SchemaPath columnName) {
        return this.columnsStatistics.get(columnName);
    }

    @Override
    public Object getStatistic(StatisticsKind statisticsKind) {
        return this.partitionStatistics.get(statisticsKind.getName());
    }

    @Override
    public boolean containsExactStatistics(StatisticsKind statisticsKind) {
        return this.statisticsKinds.get(statisticsKind.getName()).isExact();
    }

    @Override
    public Object getStatisticsForColumn(SchemaPath columnName, StatisticsKind statisticsKind) {
        return this.columnsStatistics.get(columnName).getStatistic(statisticsKind);
    }

    public SchemaPath getColumn() {
        return this.column;
    }

    public Set<Path> getLocations() {
        return this.location;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }
}

