/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.permission;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.permission.AclEntry;
import oadd.org.apache.hadoop.fs.permission.AclEntryScope;
import oadd.org.apache.hadoop.fs.permission.AclEntryType;
import oadd.org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public final class AclUtil {
    public static List<AclEntry> getAclFromPermAndEntries(FsPermission perm, List<AclEntry> entries) {
        ArrayList<AclEntry> acl = Lists.newArrayListWithCapacity(entries.size() + 3);
        acl.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(perm.getUserAction()).build());
        boolean hasAccessAcl = false;
        Iterator<AclEntry> entryIter = entries.iterator();
        AclEntry curEntry = null;
        while (entryIter.hasNext() && (curEntry = entryIter.next()).getScope() != AclEntryScope.DEFAULT) {
            hasAccessAcl = true;
            acl.add(curEntry);
        }
        acl.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(hasAccessAcl ? AclEntryType.MASK : AclEntryType.GROUP).setPermission(perm.getGroupAction()).build());
        acl.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).setPermission(perm.getOtherAction()).build());
        if (curEntry != null && curEntry.getScope() == AclEntryScope.DEFAULT) {
            acl.add(curEntry);
            while (entryIter.hasNext()) {
                acl.add(entryIter.next());
            }
        }
        return acl;
    }

    public static List<AclEntry> getMinimalAcl(FsPermission perm) {
        return Lists.newArrayList(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(perm.getUserAction()).build(), new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).setPermission(perm.getGroupAction()).build(), new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).setPermission(perm.getOtherAction()).build());
    }

    public static boolean isMinimalAcl(List<AclEntry> entries) {
        return entries.size() == 3;
    }

    private AclUtil() {
    }
}

