/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.serializer;

import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.conf.Configured;
import oadd.org.apache.hadoop.io.serializer.Deserializer;
import oadd.org.apache.hadoop.io.serializer.Serialization;
import oadd.org.apache.hadoop.io.serializer.Serializer;
import oadd.org.apache.hadoop.io.serializer.WritableSerialization;
import oadd.org.apache.hadoop.io.serializer.avro.AvroReflectSerialization;
import oadd.org.apache.hadoop.io.serializer.avro.AvroSpecificSerialization;
import oadd.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class SerializationFactory
extends Configured {
    private static final Log LOG = LogFactory.getLog(SerializationFactory.class.getName());
    private List<Serialization<?>> serializations = new ArrayList();

    public SerializationFactory(Configuration conf) {
        super(conf);
        for (String serializerName : conf.getTrimmedStrings("oadd.io.serializations", WritableSerialization.class.getName(), AvroSpecificSerialization.class.getName(), AvroReflectSerialization.class.getName())) {
            this.add(conf, serializerName);
        }
    }

    private void add(Configuration conf, String serializationName) {
        try {
            Class<?> serializionClass = conf.getClassByName(serializationName);
            this.serializations.add((Serialization)ReflectionUtils.newInstance(serializionClass, this.getConf()));
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Serialization class not found: ", e);
        }
    }

    public <T> Serializer<T> getSerializer(Class<T> c) {
        Serialization<T> serializer = this.getSerialization(c);
        if (serializer != null) {
            return serializer.getSerializer(c);
        }
        return null;
    }

    public <T> Deserializer<T> getDeserializer(Class<T> c) {
        Serialization<T> serializer = this.getSerialization(c);
        if (serializer != null) {
            return serializer.getDeserializer(c);
        }
        return null;
    }

    public <T> Serialization<T> getSerialization(Class<T> c) {
        for (Serialization<T> serialization : this.serializations) {
            if (!serialization.accept(c)) continue;
            return serialization;
        }
        return null;
    }
}

