/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2.lib;

import java.lang.reflect.Method;
import java.util.Set;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.metrics2.MetricsRecordBuilder;
import oadd.org.apache.hadoop.metrics2.lib.MetricsRegistry;
import oadd.org.apache.hadoop.metrics2.lib.MutableMetric;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableRates
extends MutableMetric {
    static final Log LOG = LogFactory.getLog(MutableRates.class);
    private final MetricsRegistry registry;
    private final Set<Class<?>> protocolCache = Sets.newHashSet();

    MutableRates(MetricsRegistry registry) {
        this.registry = Preconditions.checkNotNull(registry, "metrics registry");
    }

    public void init(Class<?> protocol) {
        if (this.protocolCache.contains(protocol)) {
            return;
        }
        this.protocolCache.add(protocol);
        for (Method method : protocol.getDeclaredMethods()) {
            String name = method.getName();
            LOG.debug(name);
            try {
                this.registry.newRate(name, name, false, true);
            }
            catch (Exception e) {
                LOG.error("Error creating rate metrics for " + method.getName(), e);
            }
        }
    }

    public void add(String name, long elapsed) {
        this.registry.add(name, elapsed);
    }

    @Override
    public void snapshot(MetricsRecordBuilder rb, boolean all) {
        this.registry.snapshot(rb, all);
    }
}

