/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security.authentication.util;

import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public abstract class RolloverSignerSecretProvider
extends SignerSecretProvider {
    private static Logger LOG = LoggerFactory.getLogger(RolloverSignerSecretProvider.class);
    private volatile byte[][] secrets;
    private ScheduledExecutorService scheduler;
    private boolean schedulerRunning = false;
    private boolean isDestroyed = false;

    @Override
    public void init(Properties config, ServletContext servletContext, long tokenValidity) throws Exception {
        this.initSecrets(this.generateNewSecret(), null);
        this.startScheduler(tokenValidity, tokenValidity);
    }

    protected void initSecrets(byte[] currentSecret, byte[] previousSecret) {
        this.secrets = new byte[][]{currentSecret, previousSecret};
    }

    protected synchronized void startScheduler(long initialDelay, long period) {
        if (!this.schedulerRunning) {
            this.schedulerRunning = true;
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    RolloverSignerSecretProvider.this.rollSecret();
                }
            }, initialDelay, period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void destroy() {
        if (!this.isDestroyed) {
            this.isDestroyed = true;
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
            this.schedulerRunning = false;
            super.destroy();
        }
    }

    protected synchronized void rollSecret() {
        if (!this.isDestroyed) {
            LOG.debug("rolling secret");
            byte[] newSecret = this.generateNewSecret();
            this.secrets = new byte[][]{newSecret, this.secrets[0]};
        }
    }

    protected abstract byte[] generateNewSecret();

    @Override
    public byte[] getCurrentSecret() {
        return this.secrets[0];
    }

    @Override
    public byte[][] getAllSecrets() {
        return this.secrets;
    }
}

