/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import oadd.org.apache.log4j.Logger;
import shade.org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class FourLetterWordMain {
    private static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    protected static final Logger LOG = Logger.getLogger(FourLetterWordMain.class);

    public static String send4LetterWord(String host, int port, String cmd) throws IOException {
        return FourLetterWordMain.send4LetterWord(host, port, cmd, 5000);
    }

    public static String send4LetterWord(String host, int port, String cmd, int timeout) throws IOException {
        LOG.info((Object)("connecting to " + host + " " + port));
        Socket sock = new Socket();
        InetSocketAddress hostaddress = host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port);
        BufferedReader reader = null;
        try {
            String line;
            sock.setSoTimeout(timeout);
            sock.connect(hostaddress, timeout);
            OutputStream outstream = sock.getOutputStream();
            outstream.write(cmd.getBytes());
            outstream.flush();
            sock.shutdownOutput();
            reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (SocketTimeoutException e) {
            throw new IOException("Exception while executing four letter word: " + cmd, e);
        }
        finally {
            sock.close();
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("Usage: FourLetterWordMain <host> <port> <cmd>");
        } else {
            System.out.println(FourLetterWordMain.send4LetterWord(args[0], Integer.parseInt(args[1]), args[2]));
        }
    }
}

