/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oadd.org.apache.jute.Record;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.server.DataTree;
import oadd.org.apache.zookeeper.server.Request;
import oadd.org.apache.zookeeper.server.ZooTrace;
import oadd.org.apache.zookeeper.server.persistence.FileSnap;
import oadd.org.apache.zookeeper.server.persistence.FileTxnLog;
import oadd.org.apache.zookeeper.server.persistence.SnapShot;
import oadd.org.apache.zookeeper.server.persistence.TxnLog;
import oadd.org.apache.zookeeper.server.persistence.Util;
import oadd.org.apache.zookeeper.txn.CreateSessionTxn;
import oadd.org.apache.zookeeper.txn.TxnHeader;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class FileTxnSnapLog {
    private final File dataDir;
    private final File snapDir;
    private TxnLog txnLog;
    private SnapShot snapLog;
    public static final int VERSION = 2;
    public static final String version = "version-";
    private static final Logger LOG = LoggerFactory.getLogger(FileTxnSnapLog.class);

    public FileTxnSnapLog(File dataDir, File snapDir) throws IOException {
        LOG.debug("Opening datadir:{} snapDir:{}", (Object)dataDir, (Object)snapDir);
        this.dataDir = new File(dataDir, "version-2");
        this.snapDir = new File(snapDir, "version-2");
        if (!this.dataDir.exists() && !this.dataDir.mkdirs()) {
            throw new IOException("Unable to create data directory " + this.dataDir);
        }
        if (!this.dataDir.canWrite()) {
            throw new IOException("Cannot write to data directory " + this.dataDir);
        }
        if (!this.snapDir.exists() && !this.snapDir.mkdirs()) {
            throw new IOException("Unable to create snap directory " + this.snapDir);
        }
        if (!this.snapDir.canWrite()) {
            throw new IOException("Cannot write to snap directory " + this.snapDir);
        }
        if (!this.dataDir.getPath().equals(this.snapDir.getPath())) {
            this.checkLogDir();
            this.checkSnapDir();
        }
        this.txnLog = new FileTxnLog(this.dataDir);
        this.snapLog = new FileSnap(this.snapDir);
    }

    private void checkLogDir() throws LogDirContentCheckException {
        File[] files = this.dataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Util.isSnapshotFileName(name);
            }
        });
        if (files != null && files.length > 0) {
            throw new LogDirContentCheckException("Log directory has snapshot files. Check if dataLogDir and dataDir configuration is correct.");
        }
    }

    private void checkSnapDir() throws SnapDirContentCheckException {
        File[] files = this.snapDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Util.isLogFileName(name);
            }
        });
        if (files != null && files.length > 0) {
            throw new SnapDirContentCheckException("Snapshot directory has log files. Check if dataLogDir and dataDir configuration is correct.");
        }
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getSnapDir() {
        return this.snapDir;
    }

    public long restore(DataTree dt, Map<Long, Integer> sessions, PlayBackListener listener) throws IOException {
        this.snapLog.deserialize(dt, sessions);
        return this.fastForwardFromEdits(dt, sessions, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fastForwardFromEdits(DataTree dt, Map<Long, Integer> sessions, PlayBackListener listener) throws IOException {
        FileTxnLog txnLog = new FileTxnLog(this.dataDir);
        TxnLog.TxnIterator itr = txnLog.read(dt.lastProcessedZxid + 1L);
        long highestZxid = dt.lastProcessedZxid;
        try {
            do {
                TxnHeader hdr;
                if ((hdr = itr.getHeader()) == null) {
                    long l = dt.lastProcessedZxid;
                    return l;
                }
                if (hdr.getZxid() < highestZxid && highestZxid != 0L) {
                    LOG.error("{}(higestZxid) > {}(next log) for type {}", highestZxid, hdr.getZxid(), hdr.getType());
                } else {
                    highestZxid = hdr.getZxid();
                }
                try {
                    this.processTransaction(hdr, dt, sessions, itr.getTxn());
                }
                catch (KeeperException.NoNodeException e) {
                    throw new IOException("Failed to process transaction type: " + hdr.getType() + " error: " + e.getMessage(), e);
                }
                listener.onTxnLoaded(hdr, itr.getTxn());
            } while (itr.next());
        }
        finally {
            if (itr != null) {
                itr.close();
            }
        }
        return highestZxid;
    }

    public void processTransaction(TxnHeader hdr, DataTree dt, Map<Long, Integer> sessions, Record txn) throws KeeperException.NoNodeException {
        DataTree.ProcessTxnResult rc;
        switch (hdr.getType()) {
            case -10: {
                sessions.put(hdr.getClientId(), ((CreateSessionTxn)txn).getTimeOut());
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- create session in log: 0x" + Long.toHexString(hdr.getClientId()) + " with timeout: " + ((CreateSessionTxn)txn).getTimeOut());
                }
                rc = dt.processTxn(hdr, txn);
                break;
            }
            case -11: {
                sessions.remove(hdr.getClientId());
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- close session in log: 0x" + Long.toHexString(hdr.getClientId()));
                }
                rc = dt.processTxn(hdr, txn);
                break;
            }
            default: {
                rc = dt.processTxn(hdr, txn);
            }
        }
        if (rc.err != KeeperException.Code.OK.intValue()) {
            LOG.debug("Ignoring processTxn failure hdr:" + hdr.getType() + ", error: " + rc.err + ", path: " + rc.path);
        }
    }

    public long getLastLoggedZxid() {
        FileTxnLog txnLog = new FileTxnLog(this.dataDir);
        return txnLog.getLastLoggedZxid();
    }

    public void save(DataTree dataTree, ConcurrentHashMap<Long, Integer> sessionsWithTimeouts) throws IOException {
        long lastZxid = dataTree.lastProcessedZxid;
        File snapshotFile = new File(this.snapDir, Util.makeSnapshotName(lastZxid));
        LOG.info("Snapshotting: 0x{} to {}", (Object)Long.toHexString(lastZxid), (Object)snapshotFile);
        this.snapLog.serialize(dataTree, sessionsWithTimeouts, snapshotFile);
    }

    public boolean truncateLog(long zxid) throws IOException {
        this.close();
        FileTxnLog truncLog = new FileTxnLog(this.dataDir);
        boolean truncated = truncLog.truncate(zxid);
        truncLog.close();
        this.txnLog = new FileTxnLog(this.dataDir);
        this.snapLog = new FileSnap(this.snapDir);
        return truncated;
    }

    public File findMostRecentSnapshot() throws IOException {
        FileSnap snaplog = new FileSnap(this.snapDir);
        return snaplog.findMostRecentSnapshot();
    }

    public List<File> findNRecentSnapshots(int n) throws IOException {
        FileSnap snaplog = new FileSnap(this.snapDir);
        return snaplog.findNRecentSnapshots(n);
    }

    public File[] getSnapshotLogs(long zxid) {
        return FileTxnLog.getLogFiles(this.dataDir.listFiles(), zxid);
    }

    public boolean append(Request si) throws IOException {
        return this.txnLog.append(si.hdr, si.txn);
    }

    public void commit() throws IOException {
        this.txnLog.commit();
    }

    public void rollLog() throws IOException {
        this.txnLog.rollLog();
    }

    public void close() throws IOException {
        this.txnLog.close();
        this.snapLog.close();
    }

    public static class SnapDirContentCheckException
    extends DatadirException {
        public SnapDirContentCheckException(String msg) {
            super(msg);
        }
    }

    public static class LogDirContentCheckException
    extends DatadirException {
        public LogDirContentCheckException(String msg) {
            super(msg);
        }
    }

    public static class DatadirException
    extends IOException {
        public DatadirException(String msg) {
            super(msg);
        }

        public DatadirException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static interface PlayBackListener {
        public void onTxnLoaded(TxnHeader var1, Record var2);
    }
}

