/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.quorum;

import oadd.org.apache.zookeeper.server.Request;
import oadd.org.apache.zookeeper.server.RequestProcessor;
import oadd.org.apache.zookeeper.server.quorum.Leader;
import oadd.org.apache.zookeeper.server.quorum.QuorumPeer;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

class AckRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AckRequestProcessor.class);
    Leader leader;

    AckRequestProcessor(Leader leader) {
        this.leader = leader;
    }

    @Override
    public void processRequest(Request request) {
        QuorumPeer self = this.leader.self;
        if (self != null) {
            this.leader.processAck(self.getId(), request.zxid, null);
        } else {
            LOG.error("Null QuorumPeer");
        }
    }

    @Override
    public void shutdown() {
    }
}

