/*
 * Decompiled with CFR 0.152.
 */
package shade.com.esri.core.geometry;

import shade.com.esri.core.geometry.CrackAndCluster;
import shade.com.esri.core.geometry.EditShape;
import shade.com.esri.core.geometry.Envelope2D;
import shade.com.esri.core.geometry.Geometry;
import shade.com.esri.core.geometry.GeometryCursor;
import shade.com.esri.core.geometry.InternalUtils;
import shade.com.esri.core.geometry.OperatorSimplifyOGC;
import shade.com.esri.core.geometry.SpatialReference;

public class OGCStructureInternal {
    public static GeometryCursor prepare_for_ops_(GeometryCursor geoms, SpatialReference sr) {
        assert (geoms != null);
        EditShape editShape = new EditShape();
        int geomIndex = editShape.createGeometryUserIndex();
        Geometry g = geoms.next();
        while (g != null) {
            int egeom = editShape.addGeometry(g);
            editShape.setGeometryUserIndex(egeom, geomIndex, geoms.getGeometryID());
            g = geoms.next();
        }
        Envelope2D env = editShape.getEnvelope2D();
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, env, true);
        CrackAndCluster.execute(editShape, tolerance, null, true);
        return OperatorSimplifyOGC.local().execute(new EditShapeCursor(editShape, geomIndex), sr, false, null);
    }

    private static class EditShapeCursor
    extends GeometryCursor {
        EditShape m_shape;
        int m_geom;
        int m_index;

        EditShapeCursor(EditShape shape, int index) {
            this.m_shape = shape;
            this.m_geom = -1;
            this.m_index = index;
        }

        @Override
        public Geometry next() {
            if (this.m_shape != null) {
                this.m_geom = this.m_geom == -1 ? this.m_shape.getFirstGeometry() : this.m_shape.getNextGeometry(this.m_geom);
                if (this.m_geom == -1) {
                    this.m_shape = null;
                } else {
                    return this.m_shape.getGeometry(this.m_geom);
                }
            }
            return null;
        }

        @Override
        public int getGeometryID() {
            return this.m_shape.getGeometryUserIndex(this.m_geom, this.m_index);
        }
    }
}

