/*
 * Decompiled with CFR 0.152.
 */
package shade.com.esri.core.geometry;

import shade.com.esri.core.geometry.Clipper;
import shade.com.esri.core.geometry.Envelope2D;
import shade.com.esri.core.geometry.Geometry;
import shade.com.esri.core.geometry.GeometryCursor;
import shade.com.esri.core.geometry.InternalUtils;
import shade.com.esri.core.geometry.ProgressTracker;
import shade.com.esri.core.geometry.SpatialReference;
import shade.com.esri.core.geometry.SpatialReferenceImpl;

class OperatorClipCursor
extends GeometryCursor {
    GeometryCursor m_inputGeometryCursor;
    SpatialReferenceImpl m_spatialRefImpl;
    Envelope2D m_envelope;
    double m_tolerance;
    int m_index = -1;

    OperatorClipCursor(GeometryCursor geoms, Envelope2D envelope, SpatialReference spatial_ref, ProgressTracker progress_tracker) {
        if (geoms == null) {
            throw new IllegalArgumentException();
        }
        this.m_envelope = envelope;
        this.m_inputGeometryCursor = geoms;
        this.m_spatialRefImpl = (SpatialReferenceImpl)spatial_ref;
        this.m_tolerance = InternalUtils.calculateToleranceFromGeometry(spatial_ref, envelope, false);
    }

    @Override
    public Geometry next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return Clipper.clip(geometry, this.m_envelope, this.m_tolerance, 0.0);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }
}

