/*
 * Decompiled with CFR 0.152.
 */
package shade.com.esri.core.geometry;

import shade.com.esri.core.geometry.AttributeStreamOfDbl;
import shade.com.esri.core.geometry.Envelope;
import shade.com.esri.core.geometry.Envelope2D;
import shade.com.esri.core.geometry.Geometry;
import shade.com.esri.core.geometry.GeometryCursor;
import shade.com.esri.core.geometry.InternalUtils;
import shade.com.esri.core.geometry.MultiPath;
import shade.com.esri.core.geometry.MultiPoint;
import shade.com.esri.core.geometry.MultiPointImpl;
import shade.com.esri.core.geometry.OperatorDifference;
import shade.com.esri.core.geometry.OperatorDifferenceCursor;
import shade.com.esri.core.geometry.Point;
import shade.com.esri.core.geometry.Point2D;
import shade.com.esri.core.geometry.Polygon;
import shade.com.esri.core.geometry.PolygonUtils;
import shade.com.esri.core.geometry.Polyline;
import shade.com.esri.core.geometry.ProgressTracker;
import shade.com.esri.core.geometry.Segment;
import shade.com.esri.core.geometry.SegmentIterator;
import shade.com.esri.core.geometry.SimpleGeometryCursor;
import shade.com.esri.core.geometry.SpatialReference;
import shade.com.esri.core.geometry.TopologicalOperations;

class OperatorDifferenceLocal
extends OperatorDifference {
    OperatorDifferenceLocal() {
    }

    @Override
    public GeometryCursor execute(GeometryCursor inputGeometries, GeometryCursor subtractor, SpatialReference sr, ProgressTracker progressTracker) {
        return new OperatorDifferenceCursor(inputGeometries, subtractor, sr, progressTracker);
    }

    @Override
    public Geometry execute(Geometry inputGeometry, Geometry subtractor, SpatialReference sr, ProgressTracker progressTracker) {
        SimpleGeometryCursor inputGeomCurs = new SimpleGeometryCursor(inputGeometry);
        SimpleGeometryCursor subractorCurs = new SimpleGeometryCursor(subtractor);
        GeometryCursor geometryCursor = this.execute(inputGeomCurs, subractorCurs, sr, progressTracker);
        return geometryCursor.next();
    }

    static Geometry difference(Geometry geometry_a, Geometry geometry_b, SpatialReference spatial_reference, ProgressTracker progress_tracker) {
        int dimension_b;
        if (geometry_a.isEmpty() || geometry_b.isEmpty()) {
            return geometry_a;
        }
        int dimension_a = geometry_a.getDimension();
        if (dimension_a > (dimension_b = geometry_b.getDimension())) {
            return geometry_a;
        }
        int type_a = geometry_a.getType().value();
        int type_b = geometry_b.getType().value();
        Envelope2D env_a = new Envelope2D();
        Envelope2D env_b = new Envelope2D();
        Envelope2D env_merged = new Envelope2D();
        geometry_a.queryEnvelope2D(env_a);
        geometry_b.queryEnvelope2D(env_b);
        env_merged.setCoords(env_a);
        env_merged.merge(env_b);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(spatial_reference, env_merged, false);
        double tolerance_cluster = tolerance * Math.sqrt(2.0) * 1.00001;
        Envelope2D env_a_inflated = new Envelope2D();
        env_a_inflated.setCoords(env_a);
        env_a_inflated.inflate(tolerance_cluster, tolerance_cluster);
        if (!env_a_inflated.isIntersecting(env_b)) {
            return geometry_a;
        }
        if (type_a == 33) {
            Geometry geometry_b_;
            if (MultiPath.isSegment(type_b)) {
                geometry_b_ = new Polyline(geometry_b.getDescription());
                ((Polyline)geometry_b_).addSegment((Segment)geometry_b, true);
            } else {
                geometry_b_ = geometry_b;
            }
            switch (type_b) {
                case 1736: {
                    return OperatorDifferenceLocal.pointMinusPolygon_((Point)geometry_a, (Polygon)geometry_b_, tolerance, progress_tracker);
                }
                case 1607: {
                    return OperatorDifferenceLocal.pointMinusPolyline_((Point)geometry_a, (Polyline)geometry_b_, tolerance, progress_tracker);
                }
                case 550: {
                    return OperatorDifferenceLocal.pointMinusMultiPoint_((Point)geometry_a, (MultiPoint)geometry_b_, tolerance, progress_tracker);
                }
                case 197: {
                    return OperatorDifferenceLocal.pointMinusEnvelope_((Point)geometry_a, (Envelope)geometry_b_, tolerance, progress_tracker);
                }
                case 33: {
                    return OperatorDifferenceLocal.pointMinusPoint_((Point)geometry_a, (Point)geometry_b_, tolerance, progress_tracker);
                }
            }
            throw new IllegalArgumentException();
        }
        if (type_a == 550) {
            switch (type_b) {
                case 1736: {
                    return OperatorDifferenceLocal.multiPointMinusPolygon_((MultiPoint)geometry_a, (Polygon)geometry_b, tolerance, progress_tracker);
                }
                case 197: {
                    return OperatorDifferenceLocal.multiPointMinusEnvelope_((MultiPoint)geometry_a, (Envelope)geometry_b, tolerance, progress_tracker);
                }
                case 33: {
                    return OperatorDifferenceLocal.multiPointMinusPoint_((MultiPoint)geometry_a, (Point)geometry_b, tolerance, progress_tracker);
                }
            }
        }
        return TopologicalOperations.difference(geometry_a, geometry_b, spatial_reference, progress_tracker);
    }

    static Geometry pointMinusPolygon_(Point point, Polygon polygon, double tolerance, ProgressTracker progress_tracker) {
        PolygonUtils.PiPResult result = PolygonUtils.isPointInPolygon2D(polygon, point, tolerance);
        if (result == PolygonUtils.PiPResult.PiPOutside) {
            return point;
        }
        return point.createInstance();
    }

    static Geometry pointMinusPolyline_(Point point, Polyline polyline, double tolerance, ProgressTracker progress_tracker) {
        Point2D pt = point.getXY();
        SegmentIterator seg_iter = polyline.querySegmentIterator();
        double tolerance_cluster = tolerance * Math.sqrt(2.0) * 1.00001;
        double tolerance_cluster_sq = tolerance_cluster * tolerance_cluster;
        Envelope2D env = new Envelope2D();
        while (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                segment.queryEnvelope2D(env);
                env.inflate(tolerance_cluster, tolerance_cluster);
                if (!env.contains(pt)) continue;
                if (segment.isIntersecting(pt, tolerance)) {
                    return point.createInstance();
                }
                Point2D end_point = segment.getStartXY();
                if (Point2D.sqrDistance(pt, end_point) <= tolerance_cluster_sq) {
                    return point.createInstance();
                }
                end_point = segment.getEndXY();
                if (!(Point2D.sqrDistance(pt, end_point) <= tolerance_cluster_sq)) continue;
                return point.createInstance();
            }
        }
        return point;
    }

    static Geometry pointMinusMultiPoint_(Point point, MultiPoint multi_point, double tolerance, ProgressTracker progress_tracker) {
        MultiPointImpl multipointImpl = (MultiPointImpl)multi_point._getImpl();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)multipointImpl.getAttributeStreamRef(0);
        int point_count = multi_point.getPointCount();
        Point2D point2D = point.getXY();
        Point2D pt = new Point2D();
        double tolerance_cluster = tolerance * Math.sqrt(2.0) * 1.00001;
        double tolerance_cluster_sq = tolerance_cluster * tolerance_cluster;
        for (int i = 0; i < point_count; ++i) {
            position.read(2 * i, pt);
            double sqr_dist = Point2D.sqrDistance(pt, point2D);
            if (!(sqr_dist <= tolerance_cluster_sq)) continue;
            return point.createInstance();
        }
        return point;
    }

    static Geometry pointMinusEnvelope_(Point point, Envelope envelope, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env = new Envelope2D();
        envelope.queryEnvelope2D(env);
        env.inflate(tolerance, tolerance);
        Point2D pt = point.getXY();
        if (!env.contains(pt)) {
            return point;
        }
        return point.createInstance();
    }

    static Geometry pointMinusPoint_(Point point_a, Point point_b, double tolerance, ProgressTracker progress_tracker) {
        Point2D pt_b;
        double tolerance_cluster = tolerance * Math.sqrt(2.0) * 1.00001;
        double tolerance_cluster_sq = tolerance_cluster * tolerance_cluster;
        Point2D pt_a = point_a.getXY();
        if (Point2D.sqrDistance(pt_a, pt_b = point_b.getXY()) <= tolerance_cluster_sq) {
            return point_a.createInstance();
        }
        return point_a;
    }

    static Geometry multiPointMinusPolygon_(MultiPoint multi_point, Polygon polygon, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env = new Envelope2D();
        polygon.queryEnvelope2D(env);
        env.inflate(tolerance, tolerance);
        int point_count = multi_point.getPointCount();
        boolean b_found_covered = false;
        boolean[] covered = new boolean[point_count];
        for (int i = 0; i < point_count; ++i) {
            covered[i] = false;
        }
        Point2D pt = new Point2D();
        for (int i = 0; i < point_count; ++i) {
            PolygonUtils.PiPResult result;
            multi_point.getXY(i, pt);
            if (!env.contains(pt) || (result = PolygonUtils.isPointInPolygon2D(polygon, pt, tolerance)) == PolygonUtils.PiPResult.PiPOutside) continue;
            b_found_covered = true;
            covered[i] = true;
        }
        if (!b_found_covered) {
            return multi_point;
        }
        MultiPoint new_multipoint = (MultiPoint)multi_point.createInstance();
        for (int i = 0; i < point_count; ++i) {
            if (covered[i]) continue;
            new_multipoint.add(multi_point, i, i + 1);
        }
        return new_multipoint;
    }

    static Geometry multiPointMinusEnvelope_(MultiPoint multi_point, Envelope envelope, double tolerance, ProgressTracker progress_tracker) {
        Envelope2D env = new Envelope2D();
        envelope.queryEnvelope2D(env);
        env.inflate(tolerance, tolerance);
        int point_count = multi_point.getPointCount();
        boolean b_found_covered = false;
        boolean[] covered = new boolean[point_count];
        for (int i = 0; i < point_count; ++i) {
            covered[i] = false;
        }
        Point2D pt = new Point2D();
        for (int i = 0; i < point_count; ++i) {
            multi_point.getXY(i, pt);
            if (!env.contains(pt)) continue;
            b_found_covered = true;
            covered[i] = true;
        }
        if (!b_found_covered) {
            return multi_point;
        }
        MultiPoint new_multipoint = (MultiPoint)multi_point.createInstance();
        for (int i = 0; i < point_count; ++i) {
            if (covered[i]) continue;
            new_multipoint.add(multi_point, i, i + 1);
        }
        return new_multipoint;
    }

    static Geometry multiPointMinusPoint_(MultiPoint multi_point, Point point, double tolerance, ProgressTracker progress_tracker) {
        MultiPointImpl multipointImpl = (MultiPointImpl)multi_point._getImpl();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)multipointImpl.getAttributeStreamRef(0);
        int point_count = multi_point.getPointCount();
        Point2D point2D = point.getXY();
        Point2D pt = new Point2D();
        boolean b_found_covered = false;
        boolean[] covered = new boolean[point_count];
        for (int i = 0; i < point_count; ++i) {
            covered[i] = false;
        }
        double tolerance_cluster = tolerance * Math.sqrt(2.0) * 1.00001;
        double tolerance_cluster_sq = tolerance_cluster * tolerance_cluster;
        for (int i = 0; i < point_count; ++i) {
            position.read(2 * i, pt);
            double sqr_dist = Point2D.sqrDistance(pt, point2D);
            if (!(sqr_dist <= tolerance_cluster_sq)) continue;
            b_found_covered = true;
            covered[i] = true;
        }
        if (!b_found_covered) {
            return multi_point;
        }
        MultiPoint new_multipoint = (MultiPoint)multi_point.createInstance();
        for (int i = 0; i < point_count; ++i) {
            if (covered[i]) continue;
            new_multipoint.add(multi_point, i, i + 1);
        }
        return new_multipoint;
    }
}

