/*
 * Decompiled with CFR 0.152.
 */
package shade.com.esri.core.geometry;

import shade.com.esri.core.geometry.AttributeStreamBase;
import shade.com.esri.core.geometry.AttributeStreamOfDbl;
import shade.com.esri.core.geometry.AttributeStreamOfInt32;
import shade.com.esri.core.geometry.AttributeStreamOfInt8;
import shade.com.esri.core.geometry.Envelope;
import shade.com.esri.core.geometry.Geometry;
import shade.com.esri.core.geometry.GeometryException;
import shade.com.esri.core.geometry.JSONUtils;
import shade.com.esri.core.geometry.JsonReader;
import shade.com.esri.core.geometry.JsonReaderCursor;
import shade.com.esri.core.geometry.MapGeometry;
import shade.com.esri.core.geometry.MapGeometryCursor;
import shade.com.esri.core.geometry.MultiPath;
import shade.com.esri.core.geometry.MultiPathImpl;
import shade.com.esri.core.geometry.MultiPoint;
import shade.com.esri.core.geometry.MultiPointImpl;
import shade.com.esri.core.geometry.MultiVertexGeometryImpl;
import shade.com.esri.core.geometry.NumberUtils;
import shade.com.esri.core.geometry.Point;
import shade.com.esri.core.geometry.Polygon;
import shade.com.esri.core.geometry.Polyline;
import shade.com.esri.core.geometry.SpatialReference;

class OperatorImportFromJsonCursor
extends MapGeometryCursor {
    JsonReaderCursor m_inputJsonParsers;
    int m_type;
    int m_index = -1;

    public OperatorImportFromJsonCursor(int type, JsonReaderCursor jsonParsers) {
        if (jsonParsers == null) {
            throw new IllegalArgumentException();
        }
        this.m_type = type;
        this.m_inputJsonParsers = jsonParsers;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    @Override
    public MapGeometry next() {
        JsonReader jsonParser = this.m_inputJsonParsers.next();
        if (jsonParser != null) {
            this.m_index = this.m_inputJsonParsers.getID();
            return OperatorImportFromJsonCursor.importFromJsonParser(this.m_type, jsonParser);
        }
        return null;
    }

    static MapGeometry importFromJsonParser(int gt, JsonReader parser) {
        MapGeometry mp;
        try {
            if (!JSONUtils.isObjectStart(parser)) {
                return null;
            }
            boolean bFoundSpatial_reference = false;
            boolean bFoundHasZ = false;
            boolean bFoundHasM = false;
            boolean bFoundPolygon = false;
            boolean bFoundPolyline = false;
            boolean bFoundMultiPoint = false;
            boolean bFoundX = false;
            boolean bFoundY = false;
            boolean bFoundZ = false;
            boolean bFoundM = false;
            boolean bFoundXMin = false;
            boolean bFoundYMin = false;
            boolean bFoundXMax = false;
            boolean bFoundYMax = false;
            boolean bFoundZMin = false;
            boolean bFoundZMax = false;
            boolean bFoundMMin = false;
            boolean bFoundMMax = false;
            double x = NumberUtils.NaN();
            double y = NumberUtils.NaN();
            double z = NumberUtils.NaN();
            double m = NumberUtils.NaN();
            double xmin = NumberUtils.NaN();
            double ymin = NumberUtils.NaN();
            double xmax = NumberUtils.NaN();
            double ymax = NumberUtils.NaN();
            double zmin = NumberUtils.NaN();
            double zmax = NumberUtils.NaN();
            double mmin = NumberUtils.NaN();
            double mmax = NumberUtils.NaN();
            boolean bHasZ = false;
            boolean bHasM = false;
            AttributeStreamOfDbl as = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
            AttributeStreamOfDbl bs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
            Geometry geometry = null;
            SpatialReference spatial_reference = null;
            while (parser.nextToken() != JsonReader.Token.END_OBJECT) {
                String name = parser.currentString();
                parser.nextToken();
                if (!bFoundSpatial_reference && name.equals("spatialReference")) {
                    bFoundSpatial_reference = true;
                    if (parser.currentToken() == JsonReader.Token.START_OBJECT) {
                        spatial_reference = SpatialReference.fromJson(parser);
                    } else if (parser.currentToken() != JsonReader.Token.VALUE_NULL) {
                        throw new GeometryException("failed to parse spatial reference: object or null is expected");
                    }
                } else if (!bFoundHasZ && name.equals("hasZ")) {
                    bFoundHasZ = true;
                    bHasZ = parser.currentToken() == JsonReader.Token.VALUE_TRUE;
                } else if (!bFoundHasM && name.equals("hasM")) {
                    bFoundHasM = true;
                    bHasM = parser.currentToken() == JsonReader.Token.VALUE_TRUE;
                } else {
                    if (!bFoundPolygon && name.equals("rings") && (gt == 0 || gt == 1736)) {
                        bFoundPolygon = true;
                        geometry = OperatorImportFromJsonCursor.importFromJsonMultiPath(true, parser, as, bs);
                        continue;
                    }
                    if (!bFoundPolyline && name.equals("paths") && (gt == 0 || gt == 1607)) {
                        bFoundPolyline = true;
                        geometry = OperatorImportFromJsonCursor.importFromJsonMultiPath(false, parser, as, bs);
                        continue;
                    }
                    if (!bFoundMultiPoint && name.equals("points") && (gt == 0 || gt == 550)) {
                        bFoundMultiPoint = true;
                        geometry = OperatorImportFromJsonCursor.importFromJsonMultiPoint(parser, as, bs);
                        continue;
                    }
                    if (!bFoundX && name.equals("x") && (gt == 0 || gt == 33)) {
                        bFoundX = true;
                        x = OperatorImportFromJsonCursor.readDouble(parser);
                    } else if (!bFoundY && name.equals("y") && (gt == 0 || gt == 33)) {
                        bFoundY = true;
                        y = OperatorImportFromJsonCursor.readDouble(parser);
                    } else if (!bFoundZ && name.equals("z") && (gt == 0 || gt == 33)) {
                        bFoundZ = true;
                        z = OperatorImportFromJsonCursor.readDouble(parser);
                    } else if (!bFoundM && name.equals("m") && (gt == 0 || gt == 33)) {
                        bFoundM = true;
                        m = OperatorImportFromJsonCursor.readDouble(parser);
                    }
                }
                if (!bFoundXMin && name.equals("xmin") && (gt == 0 || gt == 197)) {
                    bFoundXMin = true;
                    xmin = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundYMin && name.equals("ymin") && (gt == 0 || gt == 197)) {
                    bFoundYMin = true;
                    ymin = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundMMin && name.equals("mmin") && (gt == 0 || gt == 197)) {
                    bFoundMMin = true;
                    mmin = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundZMin && name.equals("zmin") && (gt == 0 || gt == 197)) {
                    bFoundZMin = true;
                    zmin = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundXMax && name.equals("xmax") && (gt == 0 || gt == 197)) {
                    bFoundXMax = true;
                    xmax = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundYMax && name.equals("ymax") && (gt == 0 || gt == 197)) {
                    bFoundYMax = true;
                    ymax = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundMMax && name.equals("mmax") && (gt == 0 || gt == 197)) {
                    bFoundMMax = true;
                    mmax = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundZMax && name.equals("zmax") && (gt == 0 || gt == 197)) {
                    bFoundZMax = true;
                    zmax = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                OperatorImportFromJsonCursor.windup(parser);
            }
            if (bFoundPolygon || bFoundPolyline || bFoundMultiPoint) {
                assert (geometry != null);
                MultiVertexGeometryImpl mvImpl = (MultiVertexGeometryImpl)geometry._getImpl();
                AttributeStreamOfDbl zs = null;
                AttributeStreamOfDbl ms = null;
                if (bHasZ) {
                    geometry.addAttribute(1);
                    zs = as;
                }
                if (bHasM) {
                    geometry.addAttribute(2);
                    AttributeStreamOfDbl attributeStreamOfDbl = ms = !bHasZ ? as : bs;
                }
                if (bHasZ && zs != null) {
                    mvImpl.setAttributeStreamRef(1, zs);
                }
                if (bHasM && ms != null) {
                    mvImpl.setAttributeStreamRef(2, ms);
                }
                mvImpl.notifyModified(0xFFFFFF);
            } else if (bFoundX || bFoundY || bFoundY || bFoundZ) {
                if (NumberUtils.isNaN(y)) {
                    x = NumberUtils.NaN();
                }
                Point p = new Point(x, y);
                if (bFoundZ) {
                    p.setZ(z);
                }
                if (bFoundM) {
                    p.setM(m);
                }
                geometry = p;
            } else if (bFoundXMin || bFoundYMin || bFoundXMax || bFoundYMax || bFoundZMin || bFoundZMax || bFoundMMin || bFoundMMax) {
                if (NumberUtils.isNaN(ymin) || NumberUtils.isNaN(xmax) || NumberUtils.isNaN(ymax)) {
                    xmin = NumberUtils.NaN();
                }
                Envelope e = new Envelope(xmin, ymin, xmax, ymax);
                if (bFoundZMin && bFoundZMax) {
                    e.setInterval(1, 0, zmin, zmax);
                }
                if (bFoundMMin && bFoundMMax) {
                    e.setInterval(2, 0, mmin, mmax);
                }
                geometry = e;
            }
            mp = new MapGeometry(geometry, spatial_reference);
        }
        catch (Exception e) {
            return null;
        }
        return mp;
    }

    public static MapGeometry fromJsonToUnknown(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(0, parser);
    }

    public static MapGeometry fromJsonToEnvelope(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(197, parser);
    }

    public static MapGeometry fromJsonToPoint(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(33, parser);
    }

    public static MapGeometry fromJsonToPolygon(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(1736, parser);
    }

    public static MapGeometry fromJsonToPolyline(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(1607, parser);
    }

    public static MapGeometry fromJsonToMultiPoint(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(550, parser);
    }

    private static void windup(JsonReader parser) {
        parser.skipChildren();
    }

    private static double readDouble(JsonReader parser) {
        if (parser.currentToken() == JsonReader.Token.VALUE_NULL || parser.currentToken() == JsonReader.Token.VALUE_STRING && parser.currentString().equals("NaN")) {
            return NumberUtils.NaN();
        }
        return parser.currentDoubleValue();
    }

    private static Geometry importFromJsonMultiPoint(JsonReader parser, AttributeStreamOfDbl as, AttributeStreamOfDbl bs) throws Exception {
        if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
            throw new GeometryException("failed to parse multipoint: array of vertices is expected");
        }
        int point_count = 0;
        MultiPoint multipoint = new MultiPoint();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(2, 0.0);
        double[] buf = new double[4];
        while (parser.nextToken() != JsonReader.Token.END_ARRAY) {
            int c;
            if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
                throw new GeometryException("failed to parse multipoint: array is expected, multipoint vertices consist of arrays of cooridinates");
            }
            int sz = 0;
            while (parser.nextToken() != JsonReader.Token.END_ARRAY) {
                buf[sz++] = OperatorImportFromJsonCursor.readDouble(parser);
            }
            if (sz < 2) {
                throw new GeometryException("failed to parse multipoint: each vertex array has to have at least 2 elements");
            }
            if (position.size() == 2 * point_count) {
                c = point_count * 3;
                if (c % 2 != 0) {
                    ++c;
                }
                position.resize(c);
            }
            position.write(2 * point_count, buf[0]);
            position.write(2 * point_count + 1, buf[1]);
            if (as.size() == point_count) {
                c = point_count * 3 / 2;
                if (c < 4) {
                    c = 4;
                } else if (c < 16) {
                    c = 16;
                }
                as.resize(c);
            }
            if (sz > 2) {
                as.write(point_count, buf[2]);
            } else {
                as.write(point_count, NumberUtils.NaN());
            }
            if (bs.size() == point_count) {
                c = point_count * 3 / 2;
                if (c < 4) {
                    c = 4;
                } else if (c < 16) {
                    c = 16;
                }
                bs.resize(c);
            }
            if (sz > 3) {
                bs.write(point_count, buf[3]);
            } else {
                bs.write(point_count, NumberUtils.NaN());
            }
            ++point_count;
        }
        if (point_count != 0) {
            MultiPointImpl mp_impl = (MultiPointImpl)multipoint._getImpl();
            mp_impl.resize(point_count);
            mp_impl.setAttributeStreamRef(0, position);
        }
        return multipoint;
    }

    private static Geometry importFromJsonMultiPath(boolean b_polygon, JsonReader parser, AttributeStreamOfDbl as, AttributeStreamOfDbl bs) throws Exception {
        int requiredSize;
        if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
            throw new GeometryException("failed to parse multipath: array of array of vertices is expected");
        }
        MultiPath multipath = b_polygon ? new Polygon() : new Polyline();
        AttributeStreamOfInt32 parts = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0);
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(2, 0.0);
        AttributeStreamOfInt8 pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(0);
        double[] buf = new double[4];
        double[] start = new double[4];
        int point_count = 0;
        int path_count = 0;
        byte pathFlag = b_polygon ? (byte)1 : 0;
        int n = requiredSize = b_polygon ? 3 : 2;
        while (parser.nextToken() != JsonReader.Token.END_ARRAY) {
            if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
                throw new GeometryException("failed to parse multipath: ring/path array is expected");
            }
            int pathPointCount = 0;
            boolean b_first = true;
            int sz = 0;
            int szstart = 0;
            parser.nextToken();
            while (parser.currentToken() != JsonReader.Token.END_ARRAY) {
                if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
                    throw new GeometryException("failed to parse multipath: array is expected, rings/paths vertices consist of arrays of cooridinates");
                }
                sz = 0;
                while (parser.nextToken() != JsonReader.Token.END_ARRAY) {
                    buf[sz++] = OperatorImportFromJsonCursor.readDouble(parser);
                }
                if (sz < 2) {
                    throw new GeometryException("failed to parse multipath: each vertex array has to have at least 2 elements");
                }
                parser.nextToken();
                do {
                    int c;
                    if (position.size() == point_count * 2) {
                        c = point_count * 3;
                        if (c % 2 != 0) {
                            ++c;
                        }
                        if (c < 8) {
                            c = 8;
                        } else if (c < 32) {
                            c = 32;
                        }
                        position.resize(c);
                    }
                    position.write(2 * point_count, buf[0]);
                    position.write(2 * point_count + 1, buf[1]);
                    if (as.size() == point_count) {
                        c = point_count * 3 / 2;
                        if (c < 4) {
                            c = 4;
                        } else if (c < 16) {
                            c = 16;
                        }
                        as.resize(c);
                    }
                    if (sz > 2) {
                        as.write(point_count, buf[2]);
                    } else {
                        as.write(point_count, NumberUtils.NaN());
                    }
                    if (bs.size() == point_count) {
                        c = point_count * 3 / 2;
                        if (c < 4) {
                            c = 4;
                        } else if (c < 16) {
                            c = 16;
                        }
                        bs.resize(c);
                    }
                    if (sz > 3) {
                        bs.write(point_count, buf[3]);
                    } else {
                        bs.write(point_count, NumberUtils.NaN());
                    }
                    if (b_first) {
                        ++path_count;
                        parts.add(point_count);
                        pathFlags.add(pathFlag);
                        b_first = false;
                        szstart = sz;
                        start[0] = buf[0];
                        start[1] = buf[1];
                        start[2] = buf[2];
                        start[3] = buf[3];
                    }
                    ++point_count;
                } while (++pathPointCount < requiredSize && parser.currentToken() == JsonReader.Token.END_ARRAY);
            }
            if (b_polygon && pathPointCount > requiredSize && sz == szstart && start[0] == buf[0] && start[1] == buf[1] && start[2] == buf[2] && start[3] == buf[3]) {
                --point_count;
                --pathPointCount;
            }
            if (pathPointCount != 0) continue;
        }
        if (point_count != 0) {
            parts.resize(path_count);
            pathFlags.resize(path_count);
            if (point_count > 0) {
                parts.add(point_count);
                pathFlags.add((byte)0);
            }
            MultiPathImpl mp_impl = (MultiPathImpl)multipath._getImpl();
            mp_impl.setAttributeStreamRef(0, position);
            mp_impl.setPathFlagsStreamRef(pathFlags);
            mp_impl.setPathStreamRef(parts);
        }
        return multipath;
    }
}

