/*
 * Decompiled with CFR 0.152.
 */
package shade.com.esri.core.geometry;

import shade.com.esri.core.geometry.AttributeStreamOfDbl;
import shade.com.esri.core.geometry.AttributeStreamOfInt32;
import shade.com.esri.core.geometry.Clipper;
import shade.com.esri.core.geometry.Envelope;
import shade.com.esri.core.geometry.Envelope2D;
import shade.com.esri.core.geometry.Geometry;
import shade.com.esri.core.geometry.GeometryAccelerators;
import shade.com.esri.core.geometry.GeometryCursor;
import shade.com.esri.core.geometry.GeometryException;
import shade.com.esri.core.geometry.InternalUtils;
import shade.com.esri.core.geometry.MultiPathImpl;
import shade.com.esri.core.geometry.MultiPoint;
import shade.com.esri.core.geometry.OperatorInternalRelationUtils;
import shade.com.esri.core.geometry.Point;
import shade.com.esri.core.geometry.Point2D;
import shade.com.esri.core.geometry.PointInPolygonHelper;
import shade.com.esri.core.geometry.Polygon;
import shade.com.esri.core.geometry.Polyline;
import shade.com.esri.core.geometry.ProgressTracker;
import shade.com.esri.core.geometry.QuadTreeImpl;
import shade.com.esri.core.geometry.RasterizedGeometry2D;
import shade.com.esri.core.geometry.Segment;
import shade.com.esri.core.geometry.SegmentBuffer;
import shade.com.esri.core.geometry.SegmentIteratorImpl;
import shade.com.esri.core.geometry.SimpleGeometryCursor;
import shade.com.esri.core.geometry.SpatialReference;
import shade.com.esri.core.geometry.TopologicalOperations;
import shade.com.esri.core.geometry.VertexDescription;

class OperatorIntersectionCursor
extends GeometryCursor {
    GeometryCursor m_inputGeoms;
    GeometryCursor m_smallCursor;
    ProgressTracker m_progress_tracker;
    SpatialReference m_spatial_reference;
    Geometry m_geomIntersector;
    Geometry m_geomIntersectorEmptyGeom;
    int m_geomIntersectorType;
    int m_currentGeomType;
    int m_index;
    int m_dimensionMask;
    boolean m_bEmpty;

    OperatorIntersectionCursor(GeometryCursor inputGeoms, GeometryCursor geomIntersector, SpatialReference sr, ProgressTracker progress_tracker, int dimensionMask) {
        this.m_bEmpty = geomIntersector == null;
        this.m_index = -1;
        this.m_inputGeoms = inputGeoms;
        this.m_spatial_reference = sr;
        this.m_geomIntersector = geomIntersector.next();
        this.m_geomIntersectorType = this.m_geomIntersector.getType().value();
        this.m_currentGeomType = Geometry.Type.Unknown.value();
        this.m_progress_tracker = progress_tracker;
        this.m_dimensionMask = dimensionMask;
        if (this.m_dimensionMask != -1 && (this.m_dimensionMask <= 0 || this.m_dimensionMask > 7)) {
            throw new IllegalArgumentException("bad dimension mask");
        }
    }

    @Override
    public Geometry next() {
        Geometry geom;
        if (this.m_bEmpty) {
            return null;
        }
        if (this.m_smallCursor != null) {
            geom = this.m_smallCursor.next();
            if (geom != null) {
                return geom;
            }
            this.m_smallCursor = null;
        }
        if ((geom = this.m_inputGeoms.next()) != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            if (this.m_dimensionMask == -1) {
                Geometry resGeom = this.intersect(geom);
                assert (resGeom != null);
                return resGeom;
            }
            this.m_smallCursor = this.intersectEx(geom);
            Geometry resGeom = this.m_smallCursor.next();
            assert (resGeom != null);
            return resGeom;
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    Geometry intersect(Geometry input_geom) {
        Geometry dst_geom = this.tryNativeImplementation_(input_geom);
        if (dst_geom != null) {
            return dst_geom;
        }
        Envelope2D commonExtent = InternalUtils.getMergedExtent(this.m_geomIntersector, input_geom);
        double t = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, commonExtent, true);
        Envelope2D env = new Envelope2D();
        this.m_geomIntersector.queryEnvelope2D(env);
        Envelope2D env1 = new Envelope2D();
        input_geom.queryEnvelope2D(env1);
        env.inflate(2.0 * t, 2.0 * t);
        env.intersect(env1);
        assert (!env.isEmpty());
        env.inflate(100.0 * t, 100.0 * t);
        double tol = 0.0;
        Geometry clippedIntersector = Clipper.clip(this.m_geomIntersector, env, tol, 0.0);
        Geometry clippedInputGeom = Clipper.clip(input_geom, env, tol, 0.0);
        return TopologicalOperations.intersection(clippedInputGeom, clippedIntersector, this.m_spatial_reference, this.m_progress_tracker);
    }

    GeometryCursor prepareVector_(VertexDescription descr, int dimensionMask, Geometry[] res_vec) {
        int i;
        int inext = 0;
        if ((dimensionMask & 1) != 0) {
            if (res_vec[0] == null) {
                res_vec[0] = new MultiPoint(descr);
            }
            ++inext;
        } else {
            for (i = 0; i < res_vec.length - 1; ++i) {
                res_vec[i] = res_vec[i + 1];
            }
        }
        if ((dimensionMask & 2) != 0) {
            if (res_vec[inext] == null) {
                res_vec[inext] = new Polyline(descr);
            }
            ++inext;
        } else {
            for (i = inext; i < res_vec.length - 1; ++i) {
                res_vec[i] = res_vec[i + 1];
            }
        }
        if ((dimensionMask & 4) != 0) {
            if (res_vec[inext] == null) {
                res_vec[inext] = new Polygon(descr);
            }
            ++inext;
        } else {
            for (i = inext; i < res_vec.length - 1; ++i) {
                res_vec[i] = res_vec[i + 1];
            }
        }
        if (inext != 3) {
            Geometry[] r = new Geometry[inext];
            for (int i2 = 0; i2 < inext; ++i2) {
                r[i2] = res_vec[i2];
            }
            return new SimpleGeometryCursor(r);
        }
        return new SimpleGeometryCursor(res_vec);
    }

    GeometryCursor intersectEx(Geometry input_geom) {
        assert (this.m_dimensionMask != -1);
        Geometry dst_geom = this.tryNativeImplementation_(input_geom);
        if (dst_geom != null) {
            Geometry[] res_vec = new Geometry[3];
            res_vec[dst_geom.getDimension()] = dst_geom;
            return this.prepareVector_(input_geom.getDescription(), this.m_dimensionMask, res_vec);
        }
        Envelope2D commonExtent = InternalUtils.getMergedExtent(this.m_geomIntersector, input_geom);
        double t = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, commonExtent, true);
        Envelope2D env = new Envelope2D();
        this.m_geomIntersector.queryEnvelope2D(env);
        env.inflate(2.0 * t, 2.0 * t);
        Envelope2D env1 = new Envelope2D();
        input_geom.queryEnvelope2D(env1);
        env.intersect(env1);
        assert (!env.isEmpty());
        env.inflate(100.0 * t, 100.0 * t);
        double tol = 0.0;
        Geometry clippedIntersector = Clipper.clip(this.m_geomIntersector, env, tol, 0.0);
        Geometry clippedInputGeom = Clipper.clip(input_geom, env, tol, 0.0);
        Geometry[] res_vec = TopologicalOperations.intersectionEx(clippedInputGeom, clippedIntersector, this.m_spatial_reference, this.m_progress_tracker);
        return this.prepareVector_(input_geom.getDescription(), this.m_dimensionMask, res_vec);
    }

    Geometry tryNativeImplementation_(Geometry input_geom) {
        boolean bResultIsEmpty;
        Envelope2D mergedExtent = InternalUtils.getMergedExtent(input_geom, this.m_geomIntersector);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, mergedExtent, false);
        int gtInput = input_geom.getType().value();
        boolean bInputEmpty = input_geom.isEmpty();
        boolean bGeomIntersectorEmpty = this.m_geomIntersector.isEmpty();
        boolean bl = bResultIsEmpty = bInputEmpty || bGeomIntersectorEmpty;
        if (!bResultIsEmpty) {
            Envelope2D env2D1 = new Envelope2D();
            input_geom.queryEnvelope2D(env2D1);
            Envelope2D env2D2 = new Envelope2D();
            this.m_geomIntersector.queryEnvelope2D(env2D2);
            env2D2.inflate(2.0 * tolerance, 2.0 * tolerance);
            boolean bl2 = bResultIsEmpty = !env2D1.isIntersecting(env2D2);
        }
        if (!bResultIsEmpty) {
            int res = OperatorInternalRelationUtils.quickTest2D_Accelerated_DisjointOrContains(this.m_geomIntersector, input_geom, tolerance);
            if (res == 4) {
                bResultIsEmpty = true;
            } else {
                if ((res & 2) != 0) {
                    return this.m_geomIntersector;
                }
                if ((res & 1) != 0) {
                    return input_geom;
                }
            }
        }
        if (bResultIsEmpty) {
            int dim2;
            int dim1 = Geometry.getDimensionFromType(gtInput);
            if (dim1 < (dim2 = Geometry.getDimensionFromType(this.m_geomIntersectorType))) {
                return OperatorIntersectionCursor.returnEmpty_(input_geom, bInputEmpty);
            }
            if (dim1 > dim2) {
                return this.returnEmptyIntersector_();
            }
            if (dim1 == 0) {
                if (gtInput == 550 && this.m_geomIntersectorType == 33) {
                    return this.returnEmptyIntersector_();
                }
                return OperatorIntersectionCursor.returnEmpty_(input_geom, bInputEmpty);
            }
            return OperatorIntersectionCursor.returnEmpty_(input_geom, bInputEmpty);
        }
        if ((this.m_dimensionMask == -1 || this.m_dimensionMask == 4) && gtInput == 197 && this.m_geomIntersectorType == 197) {
            Envelope env1 = (Envelope)input_geom;
            Envelope env2 = (Envelope)this.m_geomIntersector;
            Envelope2D env2D_1 = new Envelope2D();
            env1.queryEnvelope2D(env2D_1);
            Envelope2D env2D_2 = new Envelope2D();
            env2.queryEnvelope2D(env2D_2);
            env2D_1.intersect(env2D_2);
            Envelope result_env = new Envelope();
            env1.copyTo(result_env);
            result_env.setEnvelope2D(env2D_1);
            return result_env;
        }
        if (gtInput == 197 && Geometry.getDimensionFromType(this.m_geomIntersectorType) == 0 || this.m_geomIntersectorType == 197 && Geometry.getDimensionFromType(gtInput) == 0) {
            Envelope env = gtInput == 197 ? (Envelope)input_geom : (Envelope)this.m_geomIntersector;
            Geometry other = gtInput == 197 ? this.m_geomIntersector : input_geom;
            Envelope2D env_2D = new Envelope2D();
            env.queryEnvelope2D(env_2D);
            return Clipper.clip(other, env_2D, tolerance, 0.0);
        }
        if (Geometry.getDimensionFromType(gtInput) == 0 && Geometry.getDimensionFromType(this.m_geomIntersectorType) > 0 || Geometry.getDimensionFromType(gtInput) > 0 && Geometry.getDimensionFromType(this.m_geomIntersectorType) == 0) {
            double tolerance1 = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, input_geom, false);
            if (gtInput == 550) {
                return TopologicalOperations.intersection((MultiPoint)input_geom, this.m_geomIntersector, tolerance1);
            }
            if (gtInput == 33) {
                return TopologicalOperations.intersection((Point)input_geom, this.m_geomIntersector, tolerance1);
            }
            if (this.m_geomIntersectorType == 550) {
                return TopologicalOperations.intersection((MultiPoint)this.m_geomIntersector, input_geom, tolerance1);
            }
            if (this.m_geomIntersectorType == 33) {
                return TopologicalOperations.intersection((Point)this.m_geomIntersector, input_geom, tolerance1);
            }
            throw GeometryException.GeometryInternalError();
        }
        if ((this.m_dimensionMask == -1 || this.m_dimensionMask == 2) && gtInput == 1607 && this.m_geomIntersectorType == 1736) {
            return this.tryFastIntersectPolylinePolygon_((Polyline)input_geom, (Polygon)this.m_geomIntersector);
        }
        if ((this.m_dimensionMask == -1 || this.m_dimensionMask == 2) && gtInput == 1736 && this.m_geomIntersectorType == 1607) {
            return this.tryFastIntersectPolylinePolygon_((Polyline)this.m_geomIntersector, (Polygon)input_geom);
        }
        return null;
    }

    Geometry tryFastIntersectPolylinePolygon_(Polyline polyline, Polygon polygon) {
        double empiricConstantFactorPlaneSweep;
        double planesweepComplexity;
        RasterizedGeometry2D rgeom;
        MultiPathImpl polylineImpl = (MultiPathImpl)polyline._getImpl();
        MultiPathImpl polygonImpl = (MultiPathImpl)polygon._getImpl();
        double tolerance = InternalUtils.calculateToleranceFromGeometry(this.m_spatial_reference, polygon, false);
        Envelope2D clipEnvelope = new Envelope2D();
        polygonImpl.queryEnvelope2D(clipEnvelope);
        Envelope2D env1 = new Envelope2D();
        polylineImpl.queryEnvelope2D(env1);
        env1.inflate(2.0 * tolerance, 2.0 * tolerance);
        clipEnvelope.intersect(env1);
        assert (!clipEnvelope.isEmpty());
        clipEnvelope.inflate(10.0 * tolerance, 10.0 * tolerance);
        double tol = 0.0;
        Geometry clippedPolyline = Clipper.clip(polyline, clipEnvelope, tol, 0.0);
        polyline = (Polyline)clippedPolyline;
        polylineImpl = (MultiPathImpl)polyline._getImpl();
        AttributeStreamOfInt32 clipResult = new AttributeStreamOfInt32(0);
        int unresolvedSegments = -1;
        GeometryAccelerators accel = polygonImpl._getAccelerators();
        if (accel != null && (rgeom = accel.getRasterizedGeometry()) != null) {
            unresolvedSegments = 0;
            clipResult.reserve(polylineImpl.getPointCount() + polylineImpl.getPathCount());
            Envelope2D seg_env = new Envelope2D();
            SegmentIteratorImpl iter = polylineImpl.querySegmentIterator();
            while (iter.nextPath()) {
                while (iter.hasNextSegment()) {
                    Segment seg = iter.nextSegment();
                    seg.queryEnvelope2D(seg_env);
                    RasterizedGeometry2D.HitType hit = rgeom.queryEnvelopeInGeometry(seg_env);
                    if (hit == RasterizedGeometry2D.HitType.Inside) {
                        clipResult.add(1);
                        continue;
                    }
                    if (hit == RasterizedGeometry2D.HitType.Outside) {
                        clipResult.add(0);
                        continue;
                    }
                    clipResult.add(-1);
                    ++unresolvedSegments;
                }
            }
        }
        if (polygon.getPointCount() > 5) {
            double tol2 = 0.0;
            Geometry clippedPolygon = Clipper.clip(polygon, clipEnvelope, tol2, 0.0);
            polygon = (Polygon)clippedPolygon;
            polygonImpl = (MultiPathImpl)polygon._getImpl();
            accel = polygonImpl._getAccelerators();
        }
        if (unresolvedSegments < 0) {
            unresolvedSegments = polylineImpl.getSegmentCount();
        }
        double totalPoints = polylineImpl.getPointCount() + polygonImpl.getPointCount();
        double thisAlgorithmComplexity = (double)unresolvedSegments * (double)polygonImpl.getPointCount();
        if (thisAlgorithmComplexity > (planesweepComplexity = Math.log(totalPoints) * totalPoints) * (empiricConstantFactorPlaneSweep = 4.0)) {
            return null;
        }
        QuadTreeImpl polygonQuadTree = null;
        SegmentIteratorImpl polygonIter = polygonImpl.querySegmentIterator();
        if (accel != null && accel.getQuadTree() != null) {
            polygonQuadTree = accel.getQuadTree();
        }
        if (polygonQuadTree == null && polygonImpl.getPointCount() > 20) {
            polygonQuadTree = InternalUtils.buildQuadTree(polygonImpl);
        }
        Polyline result_polyline = (Polyline)polyline.createInstance();
        MultiPathImpl resultPolylineImpl = (MultiPathImpl)result_polyline._getImpl();
        QuadTreeImpl.QuadTreeIteratorImpl qIter = null;
        SegmentIteratorImpl polylineIter = polylineImpl.querySegmentIterator();
        double[] params = new double[9];
        AttributeStreamOfDbl intersections = new AttributeStreamOfDbl(0);
        SegmentBuffer segmentBuffer = new SegmentBuffer();
        int start_index = -1;
        int inCount = 0;
        int segIndex = 0;
        boolean bOptimized = clipResult.size() > 0;
        int polylinePathIndex = -1;
        while (polylineIter.nextPath()) {
            polylinePathIndex = polylineIter.getPathIndex();
            int stateNewPath = 0;
            int stateAddSegment = 1;
            int stateManySegments = 2;
            int stateManySegmentsContinuePath = 2;
            int stateManySegmentsNewPath = 3;
            int state = stateNewPath;
            start_index = -1;
            inCount = 0;
            while (polylineIter.hasNextSegment()) {
                int clipStatus = bOptimized ? clipResult.get(segIndex) : -1;
                ++segIndex;
                Segment polylineSeg = polylineIter.nextSegment();
                if (clipStatus < 0) {
                    assert (clipStatus == -1);
                    if (polygonQuadTree != null) {
                        if (qIter == null) {
                            qIter = polygonQuadTree.getIterator(polylineSeg, tolerance);
                        } else {
                            qIter.resetIterator(polylineSeg, tolerance);
                        }
                        int path_index = -1;
                        int ind = qIter.next();
                        while (ind != -1) {
                            polygonIter.resetToVertex(polygonQuadTree.getElement(ind));
                            path_index = polygonIter.getPathIndex();
                            Segment polygonSeg = polygonIter.nextSegment();
                            int count = polylineSeg.intersect(polygonSeg, null, params, null, tolerance);
                            for (int i = 0; i < count; ++i) {
                                intersections.add(params[i]);
                            }
                            ind = qIter.next();
                        }
                    } else {
                        polygonIter.resetToFirstPath();
                        while (polygonIter.nextPath()) {
                            while (polygonIter.hasNextSegment()) {
                                Segment polygonSeg = polygonIter.nextSegment();
                                int count = polylineSeg.intersect(polygonSeg, null, params, null, tolerance);
                                for (int i = 0; i < count; ++i) {
                                    intersections.add(params[i]);
                                }
                            }
                        }
                    }
                    if (intersections.size() > 0) {
                        intersections.sort(0, intersections.size());
                        double t0 = 0.0;
                        intersections.add(1.0);
                        int status = -1;
                        int n = intersections.size();
                        for (int i = 0; i < n; ++i) {
                            Segment resSeg;
                            double t = intersections.get(i);
                            if (t == t0) continue;
                            boolean bWholeSegment = false;
                            if (t0 != 0.0 || t != 1.0) {
                                polylineSeg.cut(t0, t, segmentBuffer);
                                resSeg = segmentBuffer.get();
                            } else {
                                resSeg = polylineSeg;
                                bWholeSegment = true;
                            }
                            if (state >= stateManySegments) {
                                resultPolylineImpl.addSegmentsFromPath(polylineImpl, polylinePathIndex, start_index, inCount, state == stateManySegmentsNewPath);
                                if (this.analyseClipSegment_(polygon, resSeg.getStartXY(), tolerance) != 1 && this.analyseClipSegment_(polygon, resSeg, tolerance) != 1) {
                                    return null;
                                }
                                resultPolylineImpl.addSegment(resSeg, false);
                                state = stateAddSegment;
                                inCount = 0;
                            } else {
                                status = this.analyseClipSegment_(polygon, resSeg, tolerance);
                                switch (status) {
                                    case 1: {
                                        if (!bWholeSegment) {
                                            resultPolylineImpl.addSegment(resSeg, state == stateNewPath);
                                            state = stateAddSegment;
                                            break;
                                        }
                                        if (state < stateManySegments) {
                                            start_index = polylineIter.getStartPointIndex() - polylineImpl.getPathStart(polylinePathIndex);
                                            inCount = 1;
                                            if (state == stateNewPath) {
                                                state = stateManySegmentsNewPath;
                                                break;
                                            }
                                            assert (state == stateAddSegment);
                                            state = stateManySegmentsContinuePath;
                                            break;
                                        }
                                        ++inCount;
                                        break;
                                    }
                                    case 0: {
                                        state = stateNewPath;
                                        start_index = -1;
                                        inCount = 0;
                                        break;
                                    }
                                    default: {
                                        return null;
                                    }
                                }
                            }
                            t0 = t;
                        }
                    } else {
                        clipStatus = this.analyseClipSegment_(polygon, polylineSeg.getStartXY(), tolerance);
                        if (clipStatus < 0) {
                            assert (clipStatus >= 0);
                            return null;
                        }
                        assert (this.analyseClipSegment_(polygon, polylineSeg.getEndXY(), tolerance) == clipStatus);
                        if (clipStatus == 1) {
                            if (state < stateManySegments) {
                                assert (inCount == 0);
                                start_index = polylineIter.getStartPointIndex() - polylineImpl.getPathStart(polylinePathIndex);
                                if (state == stateNewPath) {
                                    state = stateManySegmentsNewPath;
                                } else {
                                    assert (state == stateAddSegment);
                                    state = stateManySegmentsContinuePath;
                                }
                            }
                            ++inCount;
                        } else {
                            assert (state < stateManySegments);
                            start_index = -1;
                            inCount = 0;
                        }
                    }
                    intersections.clear(false);
                    continue;
                }
                if (clipStatus == 0) {
                    assert (this.analyseClipSegment_(polygon, polylineSeg, tolerance) == 0);
                    assert (start_index < 0);
                    assert (inCount == 0);
                    continue;
                }
                if (clipStatus != 1) continue;
                assert (this.analyseClipSegment_(polygon, polylineSeg, tolerance) == 1);
                if (state == stateNewPath) {
                    state = stateManySegmentsNewPath;
                    start_index = polylineIter.getStartPointIndex() - polylineImpl.getPathStart(polylinePathIndex);
                } else if (state == stateAddSegment) {
                    state = stateManySegmentsContinuePath;
                    start_index = polylineIter.getStartPointIndex() - polylineImpl.getPathStart(polylinePathIndex);
                } else assert (state >= stateManySegments);
                ++inCount;
            }
            if (state < stateManySegments) continue;
            resultPolylineImpl.addSegmentsFromPath(polylineImpl, polylinePathIndex, start_index, inCount, state == stateManySegmentsNewPath);
            start_index = -1;
        }
        return result_polyline;
    }

    int analyseClipSegment_(Polygon polygon, Point2D pt, double tol) {
        int v = PointInPolygonHelper.isPointInPolygon(polygon, pt, tol);
        return v;
    }

    int analyseClipSegment_(Polygon polygon, Segment seg, double tol) {
        Point2D pt_1 = seg.getStartXY();
        Point2D pt_2 = seg.getEndXY();
        int v_1 = PointInPolygonHelper.isPointInPolygon(polygon, pt_1, tol);
        int v_2 = PointInPolygonHelper.isPointInPolygon(polygon, pt_2, tol);
        if (v_1 == 1 && v_2 == 0 || v_1 == 0 && v_2 == 1) {
            assert (false);
            return -1;
        }
        if (v_1 == 0 || v_2 == 0) {
            return 0;
        }
        if (v_1 == 1 || v_2 == 1) {
            return 1;
        }
        Point2D midPt = new Point2D();
        midPt.add(pt_1, pt_2);
        midPt.scale(0.5);
        int v = PointInPolygonHelper.isPointInPolygon(polygon, midPt, tol);
        if (v == 0) {
            return 0;
        }
        if (v == 1) {
            return 1;
        }
        return -1;
    }

    Geometry normalizeIntersectionOutput(Geometry geom, int GT_1, int GT_2) {
        if (GT_1 == 33 || GT_2 == 33) assert (geom.getType().value() == 33);
        if (GT_1 == 550 && geom.getType().value() == 33) {
            MultiPoint mp = new MultiPoint(geom.getDescription());
            if (!geom.isEmpty()) {
                mp.add((Point)geom);
            }
            return mp;
        }
        return geom;
    }

    static Geometry returnEmpty_(Geometry geom, boolean bEmpty) {
        return bEmpty ? geom : geom.createInstance();
    }

    Geometry returnEmptyIntersector_() {
        if (this.m_geomIntersectorEmptyGeom == null) {
            this.m_geomIntersectorEmptyGeom = this.m_geomIntersector.createInstance();
        }
        return this.m_geomIntersectorEmptyGeom;
    }
}

