/*
 * Decompiled with CFR 0.152.
 */
package shade.com.jayway.jsonpath.internal.function.numeric;

import java.util.List;
import shade.com.jayway.jsonpath.JsonPathException;
import shade.com.jayway.jsonpath.internal.EvaluationContext;
import shade.com.jayway.jsonpath.internal.PathRef;
import shade.com.jayway.jsonpath.internal.function.Parameter;
import shade.com.jayway.jsonpath.internal.function.PathFunction;

public abstract class AbstractAggregation
implements PathFunction {
    protected abstract void next(Number var1);

    protected abstract Number getValue();

    @Override
    public Object invoke(String currentPath, PathRef parent, Object model, EvaluationContext ctx, List<Parameter> parameters) {
        int count = 0;
        if (ctx.configuration().jsonProvider().isArray(model)) {
            Iterable<?> objects = ctx.configuration().jsonProvider().toIterable(model);
            for (Object obj : objects) {
                if (!(obj instanceof Number)) continue;
                Number value = (Number)obj;
                ++count;
                this.next(value);
            }
        }
        if (parameters != null) {
            for (Parameter param : parameters) {
                Object value = param.getValue();
                if (null == value || !(value instanceof Number)) continue;
                ++count;
                this.next((Number)value);
            }
        }
        if (count != 0) {
            return this.getValue();
        }
        throw new JsonPathException("Aggregation function attempted to calculate value using empty array");
    }
}

