/*
 * Decompiled with CFR 0.152.
 */
package shade.com.jayway.jsonpath.spi.json;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oadd.com.google.gson.Gson;
import oadd.com.google.gson.JsonArray;
import oadd.com.google.gson.JsonElement;
import oadd.com.google.gson.JsonObject;
import oadd.com.google.gson.JsonParser;
import oadd.com.google.gson.JsonPrimitive;
import shade.com.jayway.jsonpath.InvalidJsonException;
import shade.com.jayway.jsonpath.JsonPathException;
import shade.com.jayway.jsonpath.spi.json.AbstractJsonProvider;

public class GsonJsonProvider
extends AbstractJsonProvider {
    private static final JsonParser PARSER = new JsonParser();
    private final Gson gson;

    public GsonJsonProvider() {
        this(new Gson());
    }

    public GsonJsonProvider(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Object unwrap(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof JsonElement)) {
            return o;
        }
        JsonElement e = (JsonElement)o;
        if (e.isJsonNull()) {
            return null;
        }
        if (e.isJsonPrimitive()) {
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (p.isString()) {
                return p.getAsString();
            }
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isNumber()) {
                return GsonJsonProvider.unwrapNumber(p.getAsNumber());
            }
        }
        return o;
    }

    private static boolean isPrimitiveNumber(Number n) {
        return n instanceof Integer || n instanceof Double || n instanceof Long || n instanceof BigDecimal || n instanceof BigInteger;
    }

    private static Number unwrapNumber(Number n) {
        double doubleValue;
        BigDecimal bigDecimal;
        Number unwrapped = !GsonJsonProvider.isPrimitiveNumber(n) ? (Number)((bigDecimal = new BigDecimal(n.toString())).scale() <= 0 ? (Number)(bigDecimal.compareTo(new BigDecimal(Integer.MAX_VALUE)) <= 0 ? (Number)bigDecimal.intValue() : (Number)(bigDecimal.compareTo(new BigDecimal(Long.MAX_VALUE)) <= 0 ? Long.valueOf(bigDecimal.longValue()) : bigDecimal)) : (Number)(BigDecimal.valueOf(doubleValue = bigDecimal.doubleValue()).compareTo(bigDecimal) != 0 ? bigDecimal : Double.valueOf(doubleValue))) : (Number)n;
        return unwrapped;
    }

    @Override
    public Object parse(String json) throws InvalidJsonException {
        return PARSER.parse(json);
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return PARSER.parse(new InputStreamReader(jsonStream, charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        return this.gson.toJson(obj);
    }

    @Override
    public Object createArray() {
        return new JsonArray();
    }

    @Override
    public Object createMap() {
        return new JsonObject();
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof JsonArray || obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        return this.toJsonArray(obj).get(idx);
    }

    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        JsonArray arr = this.toJsonArray(array);
        if (index == arr.size()) {
            arr.add(this.createJsonElement(newValue));
        } else {
            arr.set(index, this.createJsonElement(newValue));
        }
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        JsonObject jsonObject = this.toJsonObject(obj);
        JsonElement o = jsonObject.get(key);
        if (!jsonObject.has(key)) {
            return UNDEFINED;
        }
        return this.unwrap(o);
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).add(key.toString(), this.createJsonElement(value));
        } else {
            JsonArray array;
            int index = key != null ? (key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString())) : array.size();
            if (index == (array = this.toJsonArray(obj)).size()) {
                array.add(this.createJsonElement(value));
            } else {
                array.set(index, this.createJsonElement(value));
            }
        }
    }

    @Override
    public void removeProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).remove(key.toString());
        } else {
            JsonArray array = this.toJsonArray(obj);
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            array.remove(index);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof JsonObject;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, JsonElement> entry : this.toJsonObject(obj).entrySet()) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    @Override
    public int length(Object obj) {
        JsonElement element;
        if (this.isArray(obj)) {
            return this.toJsonArray(obj).size();
        }
        if (this.isMap(obj)) {
            return this.toJsonObject(obj).entrySet().size();
        }
        if (obj instanceof JsonElement && (element = this.toJsonElement(obj)).isJsonPrimitive()) {
            return element.toString().length();
        }
        throw new JsonPathException("length operation can not applied to " + obj != null ? obj.getClass().getName() : "null");
    }

    @Override
    public Iterable<?> toIterable(Object obj) {
        JsonArray arr = this.toJsonArray(obj);
        ArrayList<Object> values = new ArrayList<Object>(arr.size());
        for (JsonElement o : arr) {
            values.add(this.unwrap(o));
        }
        return values;
    }

    private JsonElement createJsonElement(Object o) {
        return this.gson.toJsonTree(o);
    }

    private JsonArray toJsonArray(Object o) {
        return (JsonArray)o;
    }

    private JsonObject toJsonObject(Object o) {
        return (JsonObject)o;
    }

    private JsonElement toJsonElement(Object o) {
        return (JsonElement)o;
    }
}

