/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.memory;

import java.nio.ByteBuffer;
import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.memory.MemoryRequest;
import shade.com.yahoo.memory.NativeMemory;
import shade.com.yahoo.memory.UnsafeUtil;

public final class MemoryUtil {
    private MemoryUtil() {
    }

    @Deprecated
    public static void copy(Memory source, long srcOffsetBytes, Memory destination, long dstOffsetBytes, long lengthBytes) {
        NativeMemory.copy(source, srcOffsetBytes, destination, dstOffsetBytes, lengthBytes);
    }

    public static int binarySearchLongs(Memory mem, int fromLongIndex, int toLongIndex, long key) {
        UnsafeUtil.assertBounds(fromLongIndex << 3, toLongIndex - fromLongIndex << 3, mem.getCapacity());
        int low = fromLongIndex;
        int high = toLongIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = mem.getLong(mid << 3);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static Memory memoryRequestHandler(Memory origMem, long newCapacityBytes, boolean copy) {
        Memory newDstMem;
        MemoryRequest memReq = origMem.getMemoryRequest();
        if (memReq == null) {
            throw new IllegalArgumentException("Insufficient space. MemoryRequest callback cannot be null.");
        }
        Memory memory = newDstMem = copy ? memReq.request(origMem, origMem.getCapacity(), newCapacityBytes) : memReq.request(newCapacityBytes);
        if (newDstMem == null) {
            throw new IllegalArgumentException("Insufficient space and Memory returned by MemoryRequest cannot be null.");
        }
        long newCap = newDstMem.getCapacity();
        if (newCap < newCapacityBytes) {
            memReq.free(newDstMem);
            throw new IllegalArgumentException("Insufficient space and Memory returned by MemoryRequest is not the requested capacity: Returned: " + newCap + " < Requested: " + newCapacityBytes);
        }
        if (copy) {
            origMem.copy(0L, newDstMem, 0L, Math.min(origMem.getCapacity(), newCap));
            memReq.free(origMem, newDstMem);
        }
        return newDstMem;
    }

    static final void checkByteBufRO(ByteBuffer byteBuf) {
        if (byteBuf.isReadOnly()) {
            throw new RuntimeException("Cannot create a NativeMemory object using a ReadOnly ByteBuffer. Please use NativeMemory.wrap(byteBuf) instead");
        }
    }

    static final long checkBooleanArr(boolean[] booleanArray) {
        if (booleanArray == null) {
            throw new IllegalArgumentException("Input must not be null.");
        }
        if (booleanArray.length == 0) {
            MemoryUtil.throwEmpty();
        }
        return booleanArray.length << 0;
    }

    static final long checkByteArr(byte[] byteArray) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Input must not be null.");
        }
        if (byteArray.length == 0) {
            MemoryUtil.throwEmpty();
        }
        return byteArray.length << 0;
    }

    static final long checkCharArr(char[] charArray) {
        if (charArray == null) {
            throw new IllegalArgumentException("Input must not be null.");
        }
        if (charArray.length == 0) {
            MemoryUtil.throwEmpty();
        }
        return charArray.length << 1;
    }

    static final long checkShortArr(short[] shortArray) {
        if (shortArray == null) {
            throw new IllegalArgumentException("Input must not be null.");
        }
        if (shortArray.length == 0) {
            MemoryUtil.throwEmpty();
        }
        return shortArray.length << 1;
    }

    static final long checkIntArr(int[] intArray) {
        if (intArray == null) {
            throw new IllegalArgumentException("Input must not be null.");
        }
        if (intArray.length == 0) {
            MemoryUtil.throwEmpty();
        }
        return intArray.length << 2;
    }

    static final long checkLongArr(long[] longArray) {
        if (longArray == null) {
            throw new IllegalArgumentException("Input must not be null.");
        }
        if (longArray.length == 0) {
            MemoryUtil.throwEmpty();
        }
        return longArray.length << 3;
    }

    static final long checkFloatArr(float[] floatArray) {
        if (floatArray == null) {
            throw new IllegalArgumentException("Input must not be null.");
        }
        if (floatArray.length == 0) {
            MemoryUtil.throwEmpty();
        }
        return floatArray.length << 2;
    }

    static final long checkDoubleArr(double[] doubleArray) {
        if (doubleArray == null) {
            throw new IllegalArgumentException("Input must not be null.");
        }
        if (doubleArray.length == 0) {
            MemoryUtil.throwEmpty();
        }
        return doubleArray.length << 3;
    }

    private static final void throwEmpty() {
        throw new IllegalArgumentException("Input primitive array must not be empty.");
    }
}

