/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches;

import shade.com.yahoo.sketches.EquivTables;
import shade.com.yahoo.sketches.SketchesArgumentException;

public final class BinomialBoundsN {
    private static double[] deltaOfNumSDev = new double[]{0.5, 0.15865531915860265, 0.02275026189041357, 0.0013498126861731796};

    private BinomialBoundsN() {
    }

    private static double contClassicLB(double numSamplesF, double theta, double numSDev) {
        double nHat = (numSamplesF - 0.5) / theta;
        double b = numSDev * Math.sqrt((1.0 - theta) / theta);
        double d = 0.5 * b * Math.sqrt(b * b + 4.0 * nHat);
        double center = nHat + 0.5 * (b * b);
        return center - d;
    }

    private static double contClassicUB(double numSamplesF, double theta, double numSDev) {
        double nHat = (numSamplesF + 0.5) / theta;
        double b = numSDev * Math.sqrt((1.0 - theta) / theta);
        double d = 0.5 * b * Math.sqrt(b * b + 4.0 * nHat);
        double center = nHat + 0.5 * (b * b);
        return center + d;
    }

    private static long specialNStar(long numSamplesI, double p, double delta) {
        BinomialBoundsN.assertTrue(numSamplesI >= 1L);
        BinomialBoundsN.assertTrue(0.0 < p && p < 1.0);
        BinomialBoundsN.assertTrue(0.0 < delta && delta < 1.0);
        double q = 1.0 - p;
        double numSamplesF = numSamplesI;
        BinomialBoundsN.assertTrue(numSamplesF / p < 500.0);
        double curTerm = Math.pow(p, numSamplesF);
        BinomialBoundsN.assertTrue(curTerm > 1.0E-100);
        double tot = curTerm;
        long m = numSamplesI;
        while (tot <= delta) {
            curTerm = curTerm * q * (double)m / (double)(m + 1L - numSamplesI);
            tot += curTerm;
            ++m;
        }
        return m - 1L;
    }

    private static long specialNPrimeB(long numSamplesI, double p, double delta) {
        BinomialBoundsN.assertTrue(numSamplesI >= 1L);
        BinomialBoundsN.assertTrue(0.0 < p && p < 1.0);
        BinomialBoundsN.assertTrue(0.0 < delta && delta < 1.0);
        double q = 1.0 - p;
        double oneMinusDelta = 1.0 - delta;
        double numSamplesF = numSamplesI;
        double curTerm = Math.pow(p, numSamplesF);
        BinomialBoundsN.assertTrue(curTerm > 1.0E-100);
        double tot = curTerm;
        long m = numSamplesI;
        while (tot < oneMinusDelta) {
            curTerm = curTerm * q * (double)m / (double)(m + 1L - numSamplesI);
            tot += curTerm;
            ++m;
        }
        return m;
    }

    private static long specialNPrimeF(long numSamplesI, double p, double delta) {
        BinomialBoundsN.assertTrue((double)numSamplesI / p < 500.0);
        return BinomialBoundsN.specialNPrimeB(numSamplesI + 1L, p, delta);
    }

    private static double computeApproxBinoLB(long numSamplesI, double theta, int numSDev) {
        if (theta == 1.0) {
            return numSamplesI;
        }
        if (numSamplesI == 0L) {
            return 0.0;
        }
        if (numSamplesI == 1L) {
            double delta = deltaOfNumSDev[numSDev];
            double rawLB = Math.log(1.0 - delta) / Math.log(1.0 - theta);
            return Math.floor(rawLB);
        }
        if (numSamplesI > 120L) {
            double rawLB = BinomialBoundsN.contClassicLB(numSamplesI, theta, numSDev);
            return rawLB - 0.5;
        }
        if (theta > 0.99999) {
            return numSamplesI;
        }
        if (theta < (double)numSamplesI / 360.0) {
            int index = 3 * (int)numSamplesI + (numSDev - 1);
            double rawLB = BinomialBoundsN.contClassicLB(numSamplesI, theta, EquivTables.getLB(index));
            return rawLB - 0.5;
        }
        double delta = deltaOfNumSDev[numSDev];
        long nstar = BinomialBoundsN.specialNStar(numSamplesI, theta, delta);
        return nstar;
    }

    private static double computeApproxBinoUB(long numSamplesI, double theta, int numSDev) {
        if (theta == 1.0) {
            return numSamplesI;
        }
        if (numSamplesI == 0L) {
            double delta = deltaOfNumSDev[numSDev];
            double rawUB = Math.log(delta) / Math.log(1.0 - theta);
            return Math.ceil(rawUB);
        }
        if (numSamplesI > 120L) {
            double rawUB = BinomialBoundsN.contClassicUB(numSamplesI, theta, numSDev);
            return rawUB + 0.5;
        }
        if (theta > 0.99999) {
            return numSamplesI + 1L;
        }
        if (theta < (double)numSamplesI / 360.0) {
            int index = 3 * (int)numSamplesI + (numSDev - 1);
            double rawUB = BinomialBoundsN.contClassicUB(numSamplesI, theta, EquivTables.getUB(index));
            return rawUB + 0.5;
        }
        double delta = deltaOfNumSDev[numSDev];
        long nprimef = BinomialBoundsN.specialNPrimeF(numSamplesI, theta, delta);
        return nprimef;
    }

    public static double getLowerBound(long numSamples, double theta, int numSDev, boolean noDataSeen) {
        if (noDataSeen) {
            return 0.0;
        }
        BinomialBoundsN.checkArgs(numSamples, theta, numSDev);
        double lb = BinomialBoundsN.computeApproxBinoLB(numSamples, theta, numSDev);
        double numSamplesF = numSamples;
        double est = numSamplesF / theta;
        return Math.min(est, Math.max(numSamplesF, lb));
    }

    public static double getUpperBound(long numSamples, double theta, int numSDev, boolean noDataSeen) {
        if (noDataSeen) {
            return 0.0;
        }
        BinomialBoundsN.checkArgs(numSamples, theta, numSDev);
        double ub = BinomialBoundsN.computeApproxBinoUB(numSamples, theta, numSDev);
        double numSamplesF = numSamples;
        double est = numSamplesF / theta;
        return Math.max(est, ub);
    }

    static final void checkArgs(long numSamples, double theta, int numSDev) {
        if (((long)(numSDev | numSDev - 1 | 3 - numSDev) | numSamples) < 0L) {
            throw new SketchesArgumentException("numSDev must only be 1,2, or 3 and numSamples must >= 0: numSDev=" + numSDev + ", numSamples=" + numSamples);
        }
        if (theta < 0.0 || theta > 1.0) {
            throw new SketchesArgumentException("0.0 < theta <= 1.0: " + theta);
        }
    }

    private static void assertTrue(boolean truth) {
        assert (truth);
    }
}

