/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.hll;

import shade.com.yahoo.sketches.hll.BucketIterator;
import shade.com.yahoo.sketches.hll.CompositeBucketIterator;
import shade.com.yahoo.sketches.hll.Fields;
import shade.com.yahoo.sketches.hll.OnHeapHash;

final class CompressedBucketUtils {
    private static final int LO_NIBBLE_MASK = 15;
    private static final int HI_NIBBLE_MASK = 240;

    private CompressedBucketUtils() {
    }

    static byte getNibble(byte[] buckets, int index) {
        int theByte = buckets[index >> 1];
        return (byte)(((index & 1) == 0 ? theByte >> 4 : theByte) & 0xF);
    }

    static void setNibble(byte[] buckets, int index, byte newValue) {
        int byteno = index >> 1;
        byte oldValue = buckets[byteno];
        buckets[byteno] = (index & 1) == 0 ? (byte)(newValue << 4 & 0xF0 | oldValue & 0xF) : (byte)(oldValue & 0xF0 | newValue & 0xF);
    }

    static void updateNibble(byte[] buckets, int index, byte newNibble, Fields.UpdateCallback callback) {
        if (newNibble < 0) {
            return;
        }
        int byteno = index >> 1;
        byte oldValue = buckets[byteno];
        int oldLowNibble = oldValue & 0xF;
        int oldHighNibble = oldValue & 0xF0;
        if ((index & 1) == 0) {
            int newHighNibble = newNibble << 4;
            if (oldHighNibble < newHighNibble) {
                buckets[byteno] = (byte)(newHighNibble | oldLowNibble);
                int oldNib = oldHighNibble >> 4;
                callback.bucketUpdated(index, (byte)oldNib, newNibble);
            }
        } else {
            int newLoNibble = newNibble & 0xF;
            if (oldLowNibble < newLoNibble) {
                buckets[byteno] = (byte)(oldHighNibble | newLoNibble);
                callback.bucketUpdated(index, (byte)oldLowNibble, newNibble);
            }
        }
    }

    static BucketIterator getBucketIterator(final byte[] buckets, final int currMin, OnHeapHash exceptions) {
        BucketIterator exceptionsIter = exceptions.getBucketIterator();
        BucketIterator nibblesIter = new BucketIterator(){
            private int i = -1;
            private int size = buckets.length << 1;
            private byte nibble;

            @Override
            public boolean next() {
                ++this.i;
                while (this.i < this.size) {
                    this.nibble = CompressedBucketUtils.getNibble(buckets, this.i);
                    if (this.nibble > 0 && this.nibble < 15) break;
                    ++this.i;
                }
                return this.i < this.size;
            }

            @Override
            public int getKey() {
                return this.i;
            }

            @Override
            public byte getValue() {
                return (byte)(currMin + this.nibble);
            }
        };
        return new CompositeBucketIterator(nibblesIter, exceptionsIter);
    }
}

