/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.hll;

import shade.com.yahoo.memory.NativeMemory;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.hll.BucketIterator;
import shade.com.yahoo.sketches.hll.CompressedBucketUtils;
import shade.com.yahoo.sketches.hll.Fields;
import shade.com.yahoo.sketches.hll.HllUtils;
import shade.com.yahoo.sketches.hll.OnHeapHash;
import shade.com.yahoo.sketches.hll.Preamble;

final class OnHeapCompressedFields
implements Fields {
    private static final int LO_NIBBLE_MASK = 15;
    private static final int HI_NIBBLE_MASK = 240;
    private final Preamble preamble;
    private final byte[] buckets;
    private volatile OnHeapHash exceptions_;
    private volatile byte currMin = 0;
    private volatile byte currMax = (byte)14;
    private volatile int exceptionGrowthBound;
    private int numAtCurrMin;

    public OnHeapCompressedFields(Preamble preamble) {
        this.preamble = preamble;
        this.buckets = new byte[preamble.getConfigK() >>> 1];
        this.exceptions_ = new OnHeapHash(16);
        this.exceptionGrowthBound = 3 * (this.exceptions_.getFields().length >>> 2);
        this.numAtCurrMin = preamble.getConfigK();
    }

    @Override
    public Preamble getPreamble() {
        return this.preamble;
    }

    @Override
    public Fields updateBucket(int index, byte val, final Fields.UpdateCallback callback) {
        if (val <= this.currMin) {
            return this;
        }
        if (val > this.currMax) {
            final byte theOldVal = CompressedBucketUtils.getNibble(this.buckets, index);
            CompressedBucketUtils.setNibble(this.buckets, index, (byte)15);
            this.exceptions_.updateBucket(index, val, new Fields.UpdateCallback(){

                @Override
                public void bucketUpdated(int bucket, byte oldVal, byte newVal) {
                    callback.bucketUpdated(bucket, theOldVal == 15 ? oldVal : (byte)(theOldVal + OnHeapCompressedFields.this.currMin), newVal);
                }
            });
            this.adjustNumAtCurrMin(theOldVal);
            if (this.exceptions_.getNumElements() >= this.exceptionGrowthBound) {
                int[] fields = this.exceptions_.getFields();
                this.exceptionGrowthBound = 3 * (fields.length >>> 2);
                this.exceptions_.resetFields(fields.length << 1);
                this.exceptions_.boostrap(fields);
            }
        } else {
            CompressedBucketUtils.updateNibble(this.buckets, index, (byte)(val - this.currMin), new Fields.UpdateCallback(){

                @Override
                public void bucketUpdated(int bucket, byte oldVal, byte newVal) {
                    oldVal = (byte)(oldVal + OnHeapCompressedFields.this.currMin);
                    byte actualNewVal = (byte)(newVal + OnHeapCompressedFields.this.currMin);
                    OnHeapCompressedFields.this.adjustNumAtCurrMin(oldVal);
                    callback.bucketUpdated(bucket, oldVal, actualNewVal);
                }
            });
        }
        return this;
    }

    private void adjustNumAtCurrMin(byte oldVal) {
        if (oldVal == 0) {
            --this.numAtCurrMin;
            if (this.numAtCurrMin == 0) {
                while (this.numAtCurrMin == 0) {
                    this.currMin = (byte)(this.currMin + 1);
                    this.currMax = (byte)(this.currMax + 1);
                    for (int i = 0; i < this.buckets.length; ++i) {
                        byte bucket = this.buckets[i];
                        int newLowNib = (bucket & 0xF) - 1;
                        int newHighNib = (bucket & 0xF0) - 16;
                        if (newLowNib == 0) {
                            ++this.numAtCurrMin;
                        }
                        if (newHighNib == 0) {
                            ++this.numAtCurrMin;
                        }
                        this.buckets[i] = (byte)(newHighNib | newLowNib);
                    }
                }
                OnHeapHash oldExceptions = this.exceptions_;
                this.exceptions_ = new OnHeapHash(oldExceptions.getFields().length);
                BucketIterator bucketIter = oldExceptions.getBucketIterator();
                while (bucketIter.next()) {
                    this.updateBucket(bucketIter.getKey(), bucketIter.getValue(), NOOP_CB);
                }
            }
        }
    }

    @Override
    public int intoByteArray(byte[] array, int offset) {
        if (array.length - offset < 6) {
            throw new SketchesArgumentException(String.format("array too small[%,d][%,d], need at least 6 bytes", array.length, offset));
        }
        array[offset++] = 3;
        array[offset++] = this.currMin;
        new NativeMemory(array).putInt(offset, this.numAtCurrMin);
        offset += 4;
        for (byte bucket : this.buckets) {
            array[offset++] = bucket;
        }
        return this.exceptions_.intoByteArray(array, offset);
    }

    @Override
    public int numBytesToSerialize() {
        return 6 + this.buckets.length + this.exceptions_.numBytesToSerialize();
    }

    @Override
    public Fields toCompact() {
        return this;
    }

    @Override
    public BucketIterator getBucketIterator() {
        return CompressedBucketUtils.getBucketIterator(this.buckets, this.currMin, this.exceptions_);
    }

    @Override
    public Fields unionInto(Fields recipient, Fields.UpdateCallback cb) {
        return recipient.unionCompressedAndExceptions(this.buckets, this.currMin, this.exceptions_, cb);
    }

    @Override
    public Fields unionBucketIterator(BucketIterator iter, Fields.UpdateCallback callback) {
        return HllUtils.unionBucketIterator(this, iter, callback);
    }

    @Override
    public Fields unionCompressedAndExceptions(byte[] compressed, int minVal, OnHeapHash exceptions, Fields.UpdateCallback cb) {
        return this.unionBucketIterator(CompressedBucketUtils.getBucketIterator(compressed, minVal, exceptions), cb);
    }
}

