/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.hll;

import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.hll.BucketIterator;
import shade.com.yahoo.sketches.hll.CompressedBucketUtils;
import shade.com.yahoo.sketches.hll.Fields;
import shade.com.yahoo.sketches.hll.HllUtils;
import shade.com.yahoo.sketches.hll.OnHeapHash;
import shade.com.yahoo.sketches.hll.Preamble;

final class OnHeapFields
implements Fields {
    private final Preamble preamble;
    private final byte[] buckets;

    public OnHeapFields(Preamble preamble) {
        this.preamble = preamble;
        this.buckets = new byte[preamble.getConfigK()];
    }

    @Override
    public Preamble getPreamble() {
        return this.preamble;
    }

    @Override
    public Fields updateBucket(int index, byte val, Fields.UpdateCallback callback) {
        if (val > this.buckets[index]) {
            callback.bucketUpdated(index, this.buckets[index], val);
            this.buckets[index] = val;
        }
        return this;
    }

    @Override
    public int intoByteArray(byte[] array, int offset) {
        int numBytesNeeded = this.numBytesToSerialize();
        if (array.length - offset < numBytesNeeded) {
            throw new SketchesArgumentException(String.format("array too small[%,d] < [%,d]", array.length - offset, numBytesNeeded));
        }
        array[offset++] = 0;
        for (byte bucket : this.buckets) {
            array[offset++] = bucket;
        }
        return offset;
    }

    @Override
    public int numBytesToSerialize() {
        return 1 + this.buckets.length;
    }

    @Override
    public Fields toCompact() {
        return this;
    }

    @Override
    public BucketIterator getBucketIterator() {
        return new BucketIterator(){
            private int i = -1;

            @Override
            public boolean next() {
                ++this.i;
                while (this.i < OnHeapFields.this.buckets.length && OnHeapFields.this.buckets[this.i] == 0) {
                    ++this.i;
                }
                return this.i < OnHeapFields.this.buckets.length;
            }

            @Override
            public int getKey() {
                return this.i;
            }

            @Override
            public byte getValue() {
                return OnHeapFields.this.buckets[this.i];
            }
        };
    }

    @Override
    public Fields unionInto(Fields recipient, Fields.UpdateCallback cb) {
        return recipient.unionBucketIterator(this.getBucketIterator(), cb);
    }

    @Override
    public Fields unionBucketIterator(BucketIterator iter, Fields.UpdateCallback callback) {
        return HllUtils.unionBucketIterator(this, iter, callback);
    }

    @Override
    public Fields unionCompressedAndExceptions(byte[] compressed, int minVal, OnHeapHash exceptions, Fields.UpdateCallback cb) {
        return this.unionBucketIterator(CompressedBucketUtils.getBucketIterator(compressed, minVal, exceptions), cb);
    }
}

