/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.hll;

import java.util.Arrays;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.hash.MurmurHash3;
import shade.com.yahoo.sketches.hll.CouponsIterator;
import shade.com.yahoo.sketches.hll.Map;

final class SingleCouponMap
extends Map {
    private static final double RSE = 0.408 / Math.sqrt(1024.0);
    private int tableEntries_;
    private int capacityEntries_;
    private int curCountEntries_;
    private double entrySizeBytes_;
    private byte[] keysArr_;
    private short[] couponsArr_;
    private byte[] stateArr_;

    private SingleCouponMap(int keySizeBytes) {
        super(keySizeBytes);
    }

    static SingleCouponMap getInstance(int initialNumEntries, int keySizeBytes) {
        int tableEntries = SingleCouponMap.nextPrime(initialNumEntries);
        SingleCouponMap map = new SingleCouponMap(keySizeBytes);
        map.tableEntries_ = tableEntries;
        map.capacityEntries_ = (int)((double)tableEntries * 0.9375);
        map.curCountEntries_ = 0;
        map.entrySizeBytes_ = SingleCouponMap.updateEntrySizeBytes(tableEntries, keySizeBytes);
        map.keysArr_ = new byte[tableEntries * map.keySizeBytes_];
        map.couponsArr_ = new short[tableEntries];
        map.stateArr_ = new byte[(int)Math.ceil((double)tableEntries / 8.0)];
        return map;
    }

    @Override
    double update(byte[] key, short coupon) {
        int entryIndex = this.findOrInsertKey(key);
        return this.update(entryIndex, coupon);
    }

    @Override
    double update(int entryIndex, short coupon) {
        if (this.couponsArr_[entryIndex] == 0) {
            this.couponsArr_[entryIndex] = coupon;
            return 1.0;
        }
        if (this.isCoupon(entryIndex)) {
            if (this.couponsArr_[entryIndex] == coupon) {
                return 1.0;
            }
            return 0.0;
        }
        return -this.couponsArr_[entryIndex];
    }

    @Override
    double getEstimate(byte[] key) {
        int entryIndex = this.findKey(key);
        if (entryIndex < 0) {
            return 0.0;
        }
        if (this.isCoupon(entryIndex)) {
            return 1.0;
        }
        return -this.getCoupon(entryIndex);
    }

    @Override
    double getUpperBound(byte[] key) {
        return this.getEstimate(key) * (1.0 + RSE);
    }

    @Override
    double getLowerBound(byte[] key) {
        return this.getEstimate(key) * (1.0 - RSE);
    }

    @Override
    int findKey(byte[] key) {
        long[] hash = MurmurHash3.hash(key, 1234567890L);
        int entryIndex = SingleCouponMap.getIndex(hash[0], this.tableEntries_);
        int stride = SingleCouponMap.getStride(hash[1], this.tableEntries_);
        int loopIndex = entryIndex;
        do {
            if (this.couponsArr_[entryIndex] == 0) {
                return ~entryIndex;
            }
            if (!Map.arraysEqual(key, 0, this.keysArr_, entryIndex * this.keySizeBytes_, this.keySizeBytes_)) continue;
            return entryIndex;
        } while ((entryIndex = (entryIndex + stride) % this.tableEntries_) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    @Override
    int findOrInsertKey(byte[] key) {
        int entryIndex = this.findKey(key);
        if (entryIndex < 0) {
            if (this.curCountEntries_ + 1 > this.capacityEntries_) {
                this.resize();
                entryIndex = this.findKey(key);
                assert (entryIndex < 0);
            }
            System.arraycopy(key, 0, this.keysArr_, (entryIndex ^= 0xFFFFFFFF) * this.keySizeBytes_, this.keySizeBytes_);
            ++this.curCountEntries_;
        }
        return entryIndex;
    }

    @Override
    CouponsIterator getCouponsIterator(int entryIndex) {
        return new CouponsIterator(this.couponsArr_, entryIndex, 1);
    }

    @Override
    int getMaxCouponsPerEntry() {
        return 1;
    }

    @Override
    int getCapacityCouponsPerEntry() {
        return 1;
    }

    @Override
    int getActiveEntries() {
        return this.curCountEntries_;
    }

    @Override
    int getDeletedEntries() {
        return 0;
    }

    boolean isCoupon(int entryIndex) {
        return !SingleCouponMap.isBitSet(this.stateArr_, entryIndex);
    }

    short getCoupon(int entryIndex) {
        return this.couponsArr_[entryIndex];
    }

    void setCoupon(int entryIndex, short coupon, boolean isLevel) {
        this.couponsArr_[entryIndex] = coupon;
        if (isLevel) {
            SingleCouponMap.setBit(this.stateArr_, entryIndex);
        } else {
            SingleCouponMap.clearBit(this.stateArr_, entryIndex);
        }
    }

    void setLevel(int entryIndex, int level) {
        this.couponsArr_[entryIndex] = (short)level;
        SingleCouponMap.setBit(this.stateArr_, entryIndex);
    }

    @Override
    double getEntrySizeBytes() {
        return this.entrySizeBytes_;
    }

    @Override
    int getTableEntries() {
        return this.tableEntries_;
    }

    @Override
    int getCapacityEntries() {
        return this.capacityEntries_;
    }

    @Override
    int getCurrentCountEntries() {
        return this.curCountEntries_;
    }

    @Override
    long getMemoryUsageBytes() {
        long arrays = (long)this.keysArr_.length + (long)this.couponsArr_.length * 2L + (long)this.stateArr_.length;
        long other = 24L;
        return arrays + 24L;
    }

    private void resize() {
        byte[] oldKeysArr = this.keysArr_;
        short[] oldCouponsArr = this.couponsArr_;
        byte[] oldStateArr = this.stateArr_;
        int oldTableEntries = this.tableEntries_;
        this.tableEntries_ = SingleCouponMap.nextPrime((int)((double)this.curCountEntries_ / 0.6666666666666666));
        this.capacityEntries_ = (int)((double)this.tableEntries_ * 0.9375);
        this.keysArr_ = new byte[this.tableEntries_ * this.keySizeBytes_];
        this.couponsArr_ = new short[this.tableEntries_];
        this.stateArr_ = new byte[(int)Math.ceil((double)this.tableEntries_ / 8.0)];
        this.entrySizeBytes_ = SingleCouponMap.updateEntrySizeBytes(this.tableEntries_, this.keySizeBytes_);
        for (int i = 0; i < oldTableEntries; ++i) {
            if (oldCouponsArr[i] == 0) continue;
            byte[] key = Arrays.copyOfRange(oldKeysArr, i * this.keySizeBytes_, i * this.keySizeBytes_ + this.keySizeBytes_);
            this.insertEntry(key, oldCouponsArr[i], SingleCouponMap.isBitSet(oldStateArr, i));
        }
    }

    private void insertEntry(byte[] key, int coupon, boolean setStateOne) {
        long[] hash = MurmurHash3.hash(key, 1234567890L);
        int entryIndex = SingleCouponMap.getIndex(hash[0], this.tableEntries_);
        int stride = SingleCouponMap.getStride(hash[1], this.tableEntries_);
        int loopIndex = entryIndex;
        do {
            if (this.couponsArr_[entryIndex] != 0) continue;
            System.arraycopy(key, 0, this.keysArr_, entryIndex * this.keySizeBytes_, this.keySizeBytes_);
            this.setCoupon(entryIndex, (short)coupon, setStateOne);
            return;
        } while ((entryIndex = (entryIndex + stride) % this.tableEntries_) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    private static final double updateEntrySizeBytes(int tableEntries, int keySizeBytes) {
        double byteFraction = Math.ceil((double)tableEntries / 8.0) / (double)tableEntries;
        return (double)(keySizeBytes + 2) + byteFraction;
    }
}

