/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.quantiles;

import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.memory.MemoryUtil;
import shade.com.yahoo.sketches.Family;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import shade.com.yahoo.sketches.quantiles.DoublesUpdateImpl;
import shade.com.yahoo.sketches.quantiles.DoublesUtil;
import shade.com.yahoo.sketches.quantiles.PreambleUtil;
import shade.com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import shade.com.yahoo.sketches.quantiles.Util;

final class DirectUpdateDoublesSketch
extends UpdateDoublesSketch {
    private static final int MIN_DIRECT_DOUBLES_SER_VER = 3;
    private Memory mem_;

    private DirectUpdateDoublesSketch(int k) {
        super(k);
    }

    static DirectUpdateDoublesSketch newInstance(int k, Memory dstMem) {
        long memCap = dstMem.getCapacity();
        DirectUpdateDoublesSketch.checkDirectMemCapacity(k, 0L, memCap);
        Object memObj = dstMem.array();
        long memAdd = dstMem.getCumulativeOffset(0L);
        dstMem.putLong(0L, 0L);
        PreambleUtil.insertPreLongs(memObj, memAdd, 2);
        PreambleUtil.insertSerVer(memObj, memAdd, 3);
        PreambleUtil.insertFamilyID(memObj, memAdd, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(memObj, memAdd, 4);
        PreambleUtil.insertK(memObj, memAdd, k);
        if (memCap >= 32L) {
            PreambleUtil.insertN(memObj, memAdd, 0L);
            PreambleUtil.insertMinDouble(memObj, memAdd, Double.POSITIVE_INFINITY);
            PreambleUtil.insertMaxDouble(memObj, memAdd, Double.NEGATIVE_INFINITY);
        }
        DirectUpdateDoublesSketch dds = new DirectUpdateDoublesSketch(k);
        dds.mem_ = dstMem;
        return dds;
    }

    static DirectUpdateDoublesSketch wrapInstance(Memory srcMem) {
        long n;
        boolean empty;
        int k;
        int flags;
        int familyID;
        int serVer;
        int preLongs;
        long memCap = srcMem.getCapacity();
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            preLongs = srcMem.getByte(0L) & 0xFF;
            serVer = srcMem.getByte(1L) & 0xFF;
            familyID = srcMem.getByte(2L) & 0xFF;
            flags = srcMem.getByte(3L) & 0xFF;
            k = srcMem.getShort(4L) & 0xFFFF;
            empty = (flags & 4) > 0;
            n = empty ? 0L : srcMem.getLong(8L);
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            serVer = PreambleUtil.extractSerVer(memObj, memAdd);
            familyID = PreambleUtil.extractFamilyID(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            k = PreambleUtil.extractK(memObj, memAdd);
            empty = (flags & 4) > 0;
            n = empty ? 0L : PreambleUtil.extractN(memObj, memAdd);
        }
        DirectUpdateDoublesSketch.checkPreLongs(preLongs);
        Util.checkFamilyID(familyID);
        DoublesUtil.checkDoublesSerVer(serVer, 3);
        DirectUpdateDoublesSketch.checkDirectFlags(flags);
        Util.checkK(k);
        DirectUpdateDoublesSketch.checkCompact(serVer, flags);
        DirectUpdateDoublesSketch.checkDirectMemCapacity(k, n, memCap);
        DirectUpdateDoublesSketch.checkEmptyAndN(empty, n);
        DirectUpdateDoublesSketch dds = new DirectUpdateDoublesSketch(k);
        dds.mem_ = srcMem;
        return dds;
    }

    @Override
    public void update(double dataItem) {
        if (Double.isNaN(dataItem)) {
            return;
        }
        int curBBCount = this.getBaseBufferCount();
        int newBBCount = curBBCount + 1;
        long curN = this.getN();
        long newN = curN + 1L;
        int combBufItemCap = this.getCombinedBufferItemCapacity();
        if (newBBCount > combBufItemCap) {
            this.mem_ = DirectUpdateDoublesSketch.growCombinedMemBuffer(this.mem_, 2 * this.getK());
        }
        double maxValue = this.getMaxValue();
        double minValue = this.getMinValue();
        if (dataItem > maxValue) {
            this.putMaxValue(dataItem);
        }
        if (dataItem < minValue) {
            this.putMinValue(dataItem);
        }
        this.mem_.putDouble(32 + curBBCount * 8, dataItem);
        this.mem_.putByte(3L, (byte)0);
        if (newBBCount == 2 * this.k_) {
            int curMemItemCap = this.getCombinedBufferItemCapacity();
            int itemSpaceNeeded = DoublesUpdateImpl.getRequiredItemCapacity(this.k_, newN);
            if (itemSpaceNeeded > curMemItemCap) {
                this.mem_ = DirectUpdateDoublesSketch.growCombinedMemBuffer(this.mem_, itemSpaceNeeded);
            }
            DoublesSketchAccessor bbAccessor = DoublesSketchAccessor.wrap(this, true);
            bbAccessor.sort();
            long newBitPattern = DoublesUpdateImpl.inPlacePropagateCarry(0, null, bbAccessor, true, this.k_, DoublesSketchAccessor.wrap(this, true), this.getBitPattern());
            assert (newBitPattern == Util.computeBitPattern(this.k_, newN));
        }
        this.putN(newN);
    }

    @Override
    public long getN() {
        if (this.mem_.getCapacity() < 32L) {
            return 0L;
        }
        return this.mem_.getLong(8L);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public double getMinValue() {
        if (this.mem_.getCapacity() < 32L) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mem_.getDouble(16L);
    }

    @Override
    public double getMaxValue() {
        if (this.mem_.getCapacity() < 32L) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.mem_.getDouble(24L);
    }

    @Override
    public void reset() {
        if (this.mem_.getCapacity() >= 32L) {
            this.mem_.putByte(3L, (byte)4);
            this.mem_.putLong(8L, 0L);
            this.mem_.putDouble(16L, Double.POSITIVE_INFINITY);
            this.mem_.putDouble(24L, Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    int getBaseBufferCount() {
        return Util.computeBaseBufferItems(this.getK(), this.getN());
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return ((int)this.mem_.getCapacity() - 32) / 8;
    }

    @Override
    double[] getCombinedBuffer() {
        int k = this.getK();
        if (this.isEmpty()) {
            return new double[k << 1];
        }
        long n = this.getN();
        int itemCap = Util.computeCombinedBufferItemCapacity(k, n);
        double[] combinedBuffer = new double[itemCap];
        this.mem_.getDoubleArray(32L, combinedBuffer, 0, itemCap);
        return combinedBuffer;
    }

    @Override
    long getBitPattern() {
        int k = this.getK();
        long n = this.getN();
        return Util.computeBitPattern(k, n);
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    void putMinValue(double minValue) {
        if (this.mem_.getCapacity() < 32L) {
            this.mem_ = DirectUpdateDoublesSketch.growCombinedMemBuffer(this.mem_, 2 * this.getK());
        }
        this.mem_.putDouble(16L, minValue);
    }

    @Override
    void putMaxValue(double maxValue) {
        if (this.mem_.getCapacity() < 32L) {
            this.mem_ = DirectUpdateDoublesSketch.growCombinedMemBuffer(this.mem_, 2 * this.getK());
        }
        this.mem_.putDouble(24L, maxValue);
    }

    @Override
    void putN(long n) {
        if (this.mem_.getCapacity() < 32L) {
            this.mem_ = DirectUpdateDoublesSketch.growCombinedMemBuffer(this.mem_, 2 * this.getK());
        }
        this.mem_.putLong(8L, n);
    }

    @Override
    void putCombinedBuffer(double[] combinedBuffer) {
        this.mem_.putDoubleArray(32L, combinedBuffer, 0, combinedBuffer.length);
    }

    @Override
    void putBaseBufferCount(int baseBufferCount) {
    }

    @Override
    void putBitPattern(long bitPattern) {
    }

    @Override
    double[] growCombinedBuffer(int curCombBufItemCap, int itemSpaceNeeded) {
        this.mem_ = DirectUpdateDoublesSketch.growCombinedMemBuffer(this.mem_, itemSpaceNeeded);
        double[] newCombBuf = new double[itemSpaceNeeded];
        this.mem_.getDoubleArray(32L, newCombBuf, 0, curCombBufItemCap);
        return newCombBuf;
    }

    static Memory growCombinedMemBuffer(Memory mem, int itemSpaceNeeded) {
        long memBytes = mem.getCapacity();
        int needBytes = (itemSpaceNeeded << 3) + 32;
        assert ((long)needBytes > memBytes);
        Memory newMem = MemoryUtil.memoryRequestHandler(mem, needBytes, true);
        return newMem;
    }

    static void checkDirectMemCapacity(int k, long n, long memCapBytes) {
        int reqBufBytes = DirectUpdateDoublesSketch.getUpdatableStorageBytes(k, n);
        if (memCapBytes < (long)reqBufBytes) {
            throw new SketchesArgumentException("Possible corruption: Memory capacity too small: " + memCapBytes + " < " + reqBufBytes);
        }
    }

    static void checkCompact(int serVer, int flags) {
        boolean compact = serVer == 2 | (flags & 8) > 0;
        if (compact) {
            throw new SketchesArgumentException("Compact Memory is not supported for Wrap Instance.");
        }
    }

    static void checkPreLongs(int preLongs) {
        if (preLongs < 1 || preLongs > 2) {
            throw new SketchesArgumentException("Possible corruption: PreLongs must be 1 or 2: " + preLongs);
        }
    }

    static void checkDirectFlags(int flags) {
        int allowedFlags = 22;
        int flagsMask = -23;
        if ((flags & 0xFFFFFFE9) > 0) {
            throw new SketchesArgumentException("Possible corruption: Invalid flags field: Cannot be compact! " + Integer.toBinaryString(flags));
        }
    }

    static void checkEmptyAndN(boolean empty, long n) {
        if (empty && n > 0L) {
            throw new SketchesArgumentException("Possible corruption: Empty Flag = true and N > 0: " + n);
        }
    }
}

