/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.quantiles;

import java.util.Arrays;
import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.sketches.Family;
import shade.com.yahoo.sketches.quantiles.DoublesBufferAccessor;
import shade.com.yahoo.sketches.quantiles.DoublesSketch;

final class DoublesSketchAccessor
extends DoublesBufferAccessor {
    static final int BB_LVL_IDX = -1;
    private final DoublesSketch ds_;
    private final boolean forceSize_;
    private long n_;
    private int currLvl_;
    private int numItems_;
    private int offset_;

    private DoublesSketchAccessor(DoublesSketch ds, boolean forceSize, int level) {
        this.ds_ = ds;
        this.forceSize_ = forceSize;
        this.setLevel(level);
    }

    static DoublesSketchAccessor wrap(DoublesSketch ds) {
        return DoublesSketchAccessor.wrap(ds, false);
    }

    static DoublesSketchAccessor wrap(DoublesSketch ds, boolean forceSize) {
        return new DoublesSketchAccessor(ds, forceSize, -1);
    }

    DoublesSketchAccessor copyAndSetLevel(int level) {
        return new DoublesSketchAccessor(this.ds_, this.forceSize_, level);
    }

    DoublesSketchAccessor setLevel(int lvl) {
        this.currLvl_ = lvl;
        if (lvl == -1) {
            this.numItems_ = this.forceSize_ ? this.ds_.getK() * 2 : this.ds_.getBaseBufferCount();
            this.offset_ = this.ds_.isDirect() ? 32 : 0;
        } else {
            assert (lvl >= 0);
            this.numItems_ = (this.ds_.getBitPattern() & 1L << lvl) > 0L || this.forceSize_ ? this.ds_.getK() : 0;
            int levelStart = this.ds_.isCompact() ? this.ds_.getBaseBufferCount() + this.countValidLevelsBelow(lvl) * this.ds_.getK() : (2 + this.currLvl_) * this.ds_.getK();
            if (this.ds_.isDirect()) {
                int preLongsAndExtra = Family.QUANTILES.getMaxPreLongs() + 2;
                this.offset_ = preLongsAndExtra + levelStart << 3;
            } else {
                this.offset_ = levelStart;
            }
        }
        this.n_ = this.ds_.getN();
        return this;
    }

    @Override
    double get(int index) {
        assert (index >= 0 && index < this.numItems_);
        assert (this.n_ == this.ds_.getN());
        if (this.ds_.isDirect()) {
            int idxOffset = this.offset_ + (index << 3);
            return this.ds_.getMemory().getDouble(idxOffset);
        }
        return this.ds_.getCombinedBuffer()[this.offset_ + index];
    }

    @Override
    double set(int index, double value) {
        double oldVal;
        assert (index >= 0 && index < this.numItems_);
        assert (this.n_ == this.ds_.getN());
        assert (!this.ds_.isCompact());
        if (this.ds_.isDirect()) {
            int idxOffset = this.offset_ + (index << 3);
            oldVal = this.ds_.getMemory().getDouble(idxOffset);
            this.ds_.getMemory().putDouble(idxOffset, value);
        } else {
            int idxOffset = this.offset_ + index;
            oldVal = this.ds_.getCombinedBuffer()[idxOffset];
            this.ds_.getCombinedBuffer()[idxOffset] = value;
        }
        return oldVal;
    }

    @Override
    int numItems() {
        return this.numItems_;
    }

    void sort() {
        assert (!this.ds_.isCompact());
        assert (this.currLvl_ == -1);
        if (this.ds_.isDirect()) {
            double[] tmpBuffer = new double[this.numItems_];
            Memory mem = this.ds_.getMemory();
            mem.getDoubleArray(this.offset_, tmpBuffer, 0, this.numItems_);
            Arrays.sort(tmpBuffer, 0, this.numItems_);
            mem.putDoubleArray(this.offset_, tmpBuffer, 0, this.numItems_);
        } else {
            Arrays.sort(this.ds_.getCombinedBuffer(), this.offset_, this.offset_ + this.numItems_);
        }
    }

    @Override
    double[] getArray(int fromIdx, int numItems) {
        if (this.ds_.isDirect()) {
            double[] dstArray = new double[numItems];
            int offsetBytes = this.offset_ + (fromIdx << 3);
            this.ds_.getMemory().getDoubleArray(offsetBytes, dstArray, 0, numItems);
            return dstArray;
        }
        int stIdx = this.offset_ + fromIdx;
        return Arrays.copyOfRange(this.ds_.getCombinedBuffer(), stIdx, stIdx + numItems);
    }

    @Override
    void putArray(double[] srcArray, int srcIndex, int dstIndex, int numItems) {
        assert (!this.ds_.isCompact());
        if (this.ds_.isDirect()) {
            int offsetBytes = this.offset_ + (dstIndex << 3);
            this.ds_.getMemory().putDoubleArray(offsetBytes, srcArray, srcIndex, numItems);
        } else {
            int tgtIdx = this.offset_ + dstIndex;
            System.arraycopy(srcArray, srcIndex, this.ds_.getCombinedBuffer(), tgtIdx, numItems);
        }
    }

    private int countValidLevelsBelow(int tgtLvl) {
        int count = 0;
        long bitPattern = this.ds_.getBitPattern();
        for (int i = 0; i < tgtLvl && bitPattern > 0L; ++i, bitPattern >>>= 1) {
            if ((bitPattern & 1L) <= 0L) continue;
            ++count;
        }
        return count;
    }
}

