/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.quantiles;

import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.sketches.quantiles.DoublesSketch;
import shade.com.yahoo.sketches.quantiles.DoublesUnion;
import shade.com.yahoo.sketches.quantiles.DoublesUnionImpl;
import shade.com.yahoo.sketches.quantiles.DoublesUtil;
import shade.com.yahoo.sketches.quantiles.Util;

public class DoublesUnionBuilder {
    private int bMaxK = 128;
    private Memory bMem = null;

    public DoublesUnionBuilder setMaxK(int maxK) {
        Util.checkK(maxK);
        this.bMaxK = maxK;
        return this;
    }

    @Deprecated
    public DoublesUnionBuilder setK(int maxK) {
        return this.setMaxK(maxK);
    }

    public DoublesUnionBuilder initMemory(Memory mem) {
        this.bMem = mem;
        return this;
    }

    public int getMaxK() {
        return this.bMaxK;
    }

    public Memory getMemory() {
        return this.bMem;
    }

    public DoublesUnion build() {
        return this.bMem == null ? DoublesUnionImpl.heapInstance(this.bMaxK) : DoublesUnionImpl.directInstance(this.bMaxK, this.bMem);
    }

    public static DoublesUnion heapify(DoublesSketch sketch) {
        return DoublesUnionImpl.heapifyInstance(sketch);
    }

    public static DoublesUnion heapify(Memory srcMem) {
        return DoublesUnionImpl.heapifyInstance(srcMem);
    }

    public static DoublesUnion wrap(Memory mem) {
        return DoublesUnionImpl.wrapInstance(mem);
    }

    @Deprecated
    public static DoublesUnion build(DoublesSketch sketch) {
        return DoublesUnionImpl.heapifyInstance(sketch);
    }

    @Deprecated
    public static DoublesUnion build(Memory srcMem) {
        return DoublesUnionImpl.heapifyInstance(srcMem);
    }

    @Deprecated
    public static DoublesUnion copyBuild(DoublesSketch sketch) {
        return DoublesUnionImpl.heapifyInstance(DoublesUtil.copyToHeap(sketch));
    }
}

