/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.quantiles;

import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.sketches.Util;
import shade.com.yahoo.sketches.quantiles.DirectUpdateDoublesSketch;
import shade.com.yahoo.sketches.quantiles.DoublesMergeImpl;
import shade.com.yahoo.sketches.quantiles.DoublesSketch;
import shade.com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import shade.com.yahoo.sketches.quantiles.DoublesUnion;
import shade.com.yahoo.sketches.quantiles.DoublesUtil;
import shade.com.yahoo.sketches.quantiles.HeapUpdateDoublesSketch;
import shade.com.yahoo.sketches.quantiles.UpdateDoublesSketch;

final class DoublesUnionImpl
extends DoublesUnion {
    private int maxK_;
    private UpdateDoublesSketch gadget_ = null;

    private DoublesUnionImpl(int maxK) {
        this.maxK_ = maxK;
    }

    static DoublesUnionImpl heapInstance(int maxK) {
        DoublesUnionImpl union = new DoublesUnionImpl(maxK);
        return union;
    }

    static DoublesUnionImpl directInstance(int maxK, Memory dstMem) {
        DirectUpdateDoublesSketch sketch = DirectUpdateDoublesSketch.newInstance(maxK, dstMem);
        DoublesUnionImpl union = new DoublesUnionImpl(maxK);
        union.maxK_ = maxK;
        union.gadget_ = sketch;
        return union;
    }

    static DoublesUnionImpl heapifyInstance(DoublesSketch sketch) {
        int k = sketch.getK();
        DoublesUnionImpl union = new DoublesUnionImpl(k);
        union.maxK_ = k;
        union.gadget_ = DoublesUtil.copyToHeap(sketch);
        return union;
    }

    static DoublesUnionImpl heapifyInstance(Memory srcMem) {
        long n = srcMem.getLong(8L);
        int k = srcMem.getShort(4L) & 0xFFFF;
        HeapUpdateDoublesSketch sketch = n == 0L ? HeapUpdateDoublesSketch.newInstance(k) : HeapUpdateDoublesSketch.heapifyInstance(srcMem);
        DoublesUnionImpl union = new DoublesUnionImpl(k);
        union.maxK_ = k;
        union.gadget_ = sketch;
        return union;
    }

    static DoublesUnionImpl wrapInstance(Memory mem) {
        DirectUpdateDoublesSketch sketch = DirectUpdateDoublesSketch.wrapInstance(mem);
        int k = sketch.getK();
        DoublesUnionImpl union = new DoublesUnionImpl(k);
        union.maxK_ = k;
        union.gadget_ = sketch;
        return union;
    }

    @Override
    public void update(DoublesSketch sketchIn) {
        this.gadget_ = DoublesUnionImpl.updateLogic(this.maxK_, this.gadget_, sketchIn);
    }

    @Override
    public void update(Memory mem) {
        this.gadget_ = DoublesUnionImpl.updateLogic(this.maxK_, this.gadget_, HeapUpdateDoublesSketch.heapifyInstance(mem));
    }

    @Override
    public void update(double dataItem) {
        if (this.gadget_ == null) {
            this.gadget_ = HeapUpdateDoublesSketch.newInstance(this.maxK_);
        }
        this.gadget_.update(dataItem);
    }

    @Override
    public DoublesSketch getResult() {
        if (this.gadget_ == null) {
            return HeapUpdateDoublesSketch.newInstance(this.maxK_);
        }
        return DoublesUtil.copyToHeap(this.gadget_);
    }

    @Override
    public DoublesSketch getResultAndReset() {
        if (this.gadget_ == null) {
            return null;
        }
        UpdateDoublesSketch ds = this.gadget_;
        this.gadget_ = null;
        return ds;
    }

    @Override
    public void reset() {
        this.gadget_ = null;
    }

    @Override
    public boolean isEmpty() {
        return this.gadget_ == null ? true : this.gadget_.isEmpty();
    }

    @Override
    public boolean isDirect() {
        return this.gadget_ == null ? false : this.gadget_.isDirect();
    }

    @Override
    public int getMaxK() {
        return this.maxK_;
    }

    @Override
    public int getEffectiveK() {
        return this.gadget_ != null ? this.gadget_.getK() : this.maxK_;
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    @Override
    public String toString(boolean sketchSummary, boolean dataDetail) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        int maxK = this.getMaxK();
        String kStr = String.format("%,d", maxK);
        sb.append(shade.com.yahoo.sketches.quantiles.Util.LS).append("### Quantiles ").append(thisSimpleName).append(Util.LS);
        sb.append("   maxK                         : ").append(kStr);
        if (this.gadget_ == null) {
            sb.append(HeapUpdateDoublesSketch.newInstance(this.maxK_).toString());
            return sb.toString();
        }
        sb.append(this.gadget_.toString(sketchSummary, dataDetail));
        return sb.toString();
    }

    static UpdateDoublesSketch updateLogic(int myMaxK, UpdateDoublesSketch myQS, DoublesSketch other) {
        int sw1;
        int n = myQS == null ? 0 : (sw1 = myQS.isEmpty() ? 4 : 8);
        int n2 = other == null ? 0 : (other.isEmpty() ? 1 : 2);
        int outCase = 0;
        switch (sw1 |= n2) {
            case 0: {
                outCase = 0;
                break;
            }
            case 1: {
                outCase = 4;
                break;
            }
            case 2: {
                outCase = 2;
                break;
            }
            case 4: {
                outCase = 1;
                break;
            }
            case 5: {
                outCase = 1;
                break;
            }
            case 6: {
                outCase = 3;
                break;
            }
            case 8: {
                outCase = 1;
                break;
            }
            case 9: {
                outCase = 1;
                break;
            }
            case 10: {
                outCase = 3;
            }
        }
        UpdateDoublesSketch ret = null;
        switch (outCase) {
            case 0: {
                ret = null;
                break;
            }
            case 1: {
                ret = myQS;
                break;
            }
            case 2: {
                if (!other.isEstimationMode()) {
                    ret = HeapUpdateDoublesSketch.newInstance(myMaxK);
                    DoublesSketchAccessor otherAccessor = DoublesSketchAccessor.wrap(other);
                    for (int i = 0; i < otherAccessor.numItems(); ++i) {
                        ret.update(otherAccessor.get(i));
                    }
                    break;
                }
                ret = myMaxK < other.getK() ? other.downSampleInternal(other, myMaxK, null) : DoublesUtil.copyToHeap(other);
                break;
            }
            case 3: {
                if (!other.isEstimationMode()) {
                    ret = myQS;
                    DoublesSketchAccessor otherAccessor = DoublesSketchAccessor.wrap(other);
                    for (int i = 0; i < otherAccessor.numItems(); ++i) {
                        ret.update(otherAccessor.get(i));
                    }
                    break;
                }
                if (myQS.getK() <= other.getK()) {
                    DoublesMergeImpl.mergeInto(other, myQS);
                    ret = myQS;
                    break;
                }
                if (myQS.isEmpty()) {
                    if (myQS.isDirect()) {
                        Memory mem = myQS.getMemory();
                        other.putMemory(mem, false);
                        ret = DirectUpdateDoublesSketch.wrapInstance(mem);
                        break;
                    }
                    ret = DoublesUtil.copyToHeap(other);
                    break;
                }
                UpdateDoublesSketch tmp = DoublesSketch.builder().build(other.getK());
                DoublesMergeImpl.downSamplingMergeInto(myQS, tmp);
                ret = myQS.isDirect() ? DoublesSketch.builder().initMemory(myQS.getMemory()).build(other.getK()) : DoublesSketch.builder().build(other.getK());
                DoublesMergeImpl.mergeInto(tmp, ret);
                DoublesMergeImpl.mergeInto(other, ret);
                break;
            }
            case 4: {
                ret = HeapUpdateDoublesSketch.newInstance(myMaxK);
            }
        }
        return ret;
    }
}

