/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.quantiles;

import java.util.Arrays;
import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.quantiles.CompactDoublesSketch;
import shade.com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import shade.com.yahoo.sketches.quantiles.DoublesUtil;
import shade.com.yahoo.sketches.quantiles.HeapUpdateDoublesSketch;
import shade.com.yahoo.sketches.quantiles.PreambleUtil;
import shade.com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import shade.com.yahoo.sketches.quantiles.Util;

final class HeapCompactDoublesSketch
extends CompactDoublesSketch {
    static final int MIN_HEAP_DOUBLES_SER_VER = 1;
    private double minValue_;
    private double maxValue_;
    private long n_;
    private int baseBufferCount_;
    private long bitPattern_;
    private double[] combinedBuffer_;

    private HeapCompactDoublesSketch(int k) {
        super(k);
    }

    static HeapCompactDoublesSketch createFromUpdateSketch(UpdateDoublesSketch sketch) {
        int k = sketch.getK();
        long n = sketch.getN();
        HeapCompactDoublesSketch hcds = new HeapCompactDoublesSketch(k);
        hcds.n_ = n;
        hcds.bitPattern_ = Util.computeBitPattern(k, n);
        assert (hcds.bitPattern_ == sketch.getBitPattern());
        hcds.minValue_ = sketch.getMinValue();
        hcds.maxValue_ = sketch.getMaxValue();
        hcds.baseBufferCount_ = Util.computeBaseBufferItems(k, n);
        assert (hcds.baseBufferCount_ == sketch.getBaseBufferCount());
        int retainedItems = Util.computeRetainedItems(k, n);
        double[] combinedBuffer = new double[retainedItems];
        DoublesSketchAccessor accessor = DoublesSketchAccessor.wrap(sketch);
        assert (hcds.baseBufferCount_ == accessor.numItems());
        System.arraycopy(accessor.getArray(0, hcds.baseBufferCount_), 0, combinedBuffer, 0, hcds.baseBufferCount_);
        int combinedBufferOffset = hcds.baseBufferCount_;
        int lvl = 0;
        for (long bitPattern = hcds.bitPattern_; bitPattern > 0L; bitPattern >>>= 1) {
            if ((bitPattern & 1L) > 0L) {
                accessor.setLevel(lvl);
                System.arraycopy(accessor.getArray(0, k), 0, combinedBuffer, combinedBufferOffset, k);
                combinedBufferOffset += k;
            }
            ++lvl;
        }
        hcds.combinedBuffer_ = combinedBuffer;
        return hcds;
    }

    static HeapCompactDoublesSketch heapifyInstance(Memory srcMem) {
        long n;
        boolean empty;
        int k;
        int flags;
        int familyID;
        int serVer;
        int preLongs;
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new SketchesArgumentException("Source Memory too small: " + memCapBytes + " < 8");
        }
        boolean readOnly = srcMem.isReadOnly();
        boolean direct = srcMem.isDirect();
        if (readOnly && !direct) {
            preLongs = srcMem.getByte(0L) & 0xFF;
            serVer = srcMem.getByte(1L) & 0xFF;
            familyID = srcMem.getByte(2L) & 0xFF;
            flags = srcMem.getByte(3L) & 0xFF;
            k = srcMem.getShort(4L) & 0xFFFF;
            empty = (flags & 4) > 0;
            n = empty ? 0L : srcMem.getLong(8L);
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            serVer = PreambleUtil.extractSerVer(memObj, memAdd);
            familyID = PreambleUtil.extractFamilyID(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            k = PreambleUtil.extractK(memObj, memAdd);
            empty = (flags & 4) > 0;
            n = empty ? 0L : PreambleUtil.extractN(memObj, memAdd);
        }
        DoublesUtil.checkDoublesSerVer(serVer, 1);
        Util.checkHeapFlags(flags);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer(flags, serVer, preLongs);
        Util.checkFamilyID(familyID);
        HeapCompactDoublesSketch hds = new HeapCompactDoublesSketch(k);
        if (empty) {
            hds.n_ = 0L;
            hds.combinedBuffer_ = null;
            hds.baseBufferCount_ = 0;
            hds.bitPattern_ = 0L;
            hds.minValue_ = Double.POSITIVE_INFINITY;
            hds.maxValue_ = Double.NEGATIVE_INFINITY;
            return hds;
        }
        boolean srcIsCompact = serVer == 2 | (flags & 0xA) > 0;
        HeapUpdateDoublesSketch.checkHeapMemCapacity(k, n, srcIsCompact, serVer, memCapBytes);
        hds.n_ = n;
        hds.baseBufferCount_ = Util.computeBaseBufferItems(k, n);
        hds.bitPattern_ = Util.computeBitPattern(k, n);
        hds.minValue_ = srcMem.getDouble(16L);
        hds.maxValue_ = srcMem.getDouble(24L);
        int totItems = Util.computeRetainedItems(k, n);
        hds.srcMemoryToCombinedBuffer(srcMem, serVer, srcIsCompact, totItems);
        return hds;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public double getMinValue() {
        return this.minValue_;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue_;
    }

    private void srcMemoryToCombinedBuffer(Memory srcMem, int serVer, boolean srcIsCompact, int combBufCap) {
        int preLongs = 2;
        int extra = serVer == 1 ? 3 : 2;
        int preBytes = 2 + extra << 3;
        int k = this.getK();
        this.combinedBuffer_ = new double[combBufCap];
        if (srcIsCompact) {
            srcMem.getDoubleArray(preBytes, this.combinedBuffer_, 0, combBufCap);
        } else {
            srcMem.getDoubleArray(preBytes, this.combinedBuffer_, 0, this.baseBufferCount_);
            Arrays.sort(this.combinedBuffer_, 0, this.baseBufferCount_);
            int srcOffset = preBytes + (2 * k << 3);
            int dstOffset = this.baseBufferCount_;
            for (long bitPattern = this.bitPattern_; bitPattern != 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    srcMem.getDoubleArray(srcOffset, this.combinedBuffer_, dstOffset, k);
                    dstOffset += k;
                }
                srcOffset += k << 3;
            }
        }
    }

    @Override
    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return this.combinedBuffer_.length;
    }

    @Override
    double[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    @Override
    long getBitPattern() {
        return this.bitPattern_;
    }

    @Override
    Memory getMemory() {
        return null;
    }
}

