/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.quantiles;

import java.lang.reflect.Array;
import java.util.Arrays;
import shade.com.yahoo.memory.NativeMemory;
import shade.com.yahoo.sketches.ArrayOfItemsSerDe;
import shade.com.yahoo.sketches.Family;
import shade.com.yahoo.sketches.quantiles.ItemsSketch;
import shade.com.yahoo.sketches.quantiles.PreambleUtil;

final class ItemsByteArrayImpl {
    private ItemsByteArrayImpl() {
    }

    static <T> byte[] toByteArray(ItemsSketch<T> sketch, boolean ordered, ArrayOfItemsSerDe<T> serDe) {
        boolean empty = sketch.isEmpty();
        int flags = (empty ? 4 : 0) | (ordered ? 16 : 0) | 8;
        if (empty) {
            byte[] outByteArr = new byte[8];
            NativeMemory memOut = new NativeMemory(outByteArr);
            Object memObj = memOut.array();
            long memAdd = memOut.getCumulativeOffset(0L);
            boolean preLongs = true;
            ItemsByteArrayImpl.insertPre0(memObj, memAdd, 1, flags, sketch.getK());
            return outByteArr;
        }
        T[] dataArr = ItemsByteArrayImpl.combinedBufferToItemsArray(sketch, ordered);
        int preLongs = 2;
        byte[] itemsByteArr = serDe.serializeToByteArray(dataArr);
        int numOutBytes = 16 + itemsByteArr.length;
        byte[] outByteArr = new byte[numOutBytes];
        NativeMemory memOut = new NativeMemory(outByteArr);
        long cumOffset = memOut.getCumulativeOffset(0L);
        ItemsByteArrayImpl.insertPre0(outByteArr, cumOffset, 2, flags, sketch.getK());
        PreambleUtil.insertN(outByteArr, cumOffset, sketch.getN());
        memOut.putByteArray(16L, itemsByteArr, 0, itemsByteArr.length);
        return outByteArr;
    }

    private static <T> T[] combinedBufferToItemsArray(ItemsSketch<T> sketch, boolean ordered) {
        long bitPattern;
        Object[] outArr = null;
        int extra = 2;
        int outArrCap = sketch.getRetainedItems();
        T minValue = sketch.getMinValue();
        outArr = (Object[])Array.newInstance(minValue.getClass(), outArrCap + 2);
        outArr[0] = minValue;
        outArr[1] = sketch.getMaxValue();
        int baseBufferCount = sketch.getBaseBufferCount();
        Object[] combinedBuffer = sketch.getCombinedBuffer();
        System.arraycopy(combinedBuffer, 0, outArr, 2, baseBufferCount);
        if (bitPattern > 0L) {
            int k = sketch.getK();
            int index = 2 + baseBufferCount;
            int level = 0;
            for (bitPattern = sketch.getBitPattern(); bitPattern != 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    System.arraycopy(combinedBuffer, (2 + level) * k, outArr, index, k);
                    index += k;
                }
                ++level;
            }
        }
        if (ordered) {
            Arrays.sort(outArr, 2, baseBufferCount + 2, sketch.getComparator());
        }
        return outArr;
    }

    private static void insertPre0(Object memObj, long memAdd, int preLongs, int flags, int k) {
        PreambleUtil.insertPreLongs(memObj, memAdd, preLongs);
        PreambleUtil.insertSerVer(memObj, memAdd, 3);
        PreambleUtil.insertFamilyID(memObj, memAdd, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(memObj, memAdd, flags);
        PreambleUtil.insertK(memObj, memAdd, k);
    }
}

