/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.quantiles;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.memory.MemoryRegion;
import shade.com.yahoo.sketches.ArrayOfItemsSerDe;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.quantiles.ItemsAuxiliary;
import shade.com.yahoo.sketches.quantiles.ItemsByteArrayImpl;
import shade.com.yahoo.sketches.quantiles.ItemsMergeImpl;
import shade.com.yahoo.sketches.quantiles.ItemsPmfCdfImpl;
import shade.com.yahoo.sketches.quantiles.ItemsUtil;
import shade.com.yahoo.sketches.quantiles.PreambleUtil;
import shade.com.yahoo.sketches.quantiles.Util;

public final class ItemsSketch<T> {
    private final Comparator<? super T> comparator_;
    final int k_;
    long n_;
    T minValue_;
    T maxValue_;
    int combinedBufferItemCapacity_;
    int baseBufferCount_;
    long bitPattern_;
    Object[] combinedBuffer_;
    public static final Random rand = new Random();

    private ItemsSketch(int k, Comparator<? super T> comparator) {
        Util.checkK(k);
        this.k_ = k;
        this.comparator_ = comparator;
    }

    public static <T> ItemsSketch<T> getInstance(Comparator<? super T> comparator) {
        return ItemsSketch.getInstance(128, comparator);
    }

    public static <T> ItemsSketch<T> getInstance(int k, Comparator<? super T> comparator) {
        ItemsSketch<? super T> qs = new ItemsSketch<T>(k, comparator);
        int bufAlloc = 2 * Math.min(2, k);
        qs.n_ = 0L;
        qs.combinedBufferItemCapacity_ = bufAlloc;
        qs.combinedBuffer_ = new Object[bufAlloc];
        qs.baseBufferCount_ = 0;
        qs.bitPattern_ = 0L;
        qs.minValue_ = null;
        qs.maxValue_ = null;
        return qs;
    }

    public static <T> ItemsSketch<T> getInstance(Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new SketchesArgumentException("Memory too small: " + memCapBytes);
        }
        long cumOffset = srcMem.getCumulativeOffset(0L);
        Object memObj = srcMem.array();
        int preambleLongs = PreambleUtil.extractPreLongs(memObj, cumOffset);
        int serVer = PreambleUtil.extractSerVer(memObj, cumOffset);
        int familyID = PreambleUtil.extractFamilyID(memObj, cumOffset);
        int flags = PreambleUtil.extractFlags(memObj, cumOffset);
        int k = PreambleUtil.extractK(memObj, cumOffset);
        ItemsUtil.checkItemsSerVer(serVer);
        if (serVer == 3 && (flags & 8) == 0) {
            throw new SketchesArgumentException("Non-compact Memory images are not supported.");
        }
        boolean empty = Util.checkPreLongsFlagsCap(preambleLongs, flags, memCapBytes);
        Util.checkFamilyID(familyID);
        ItemsSketch<? super T> qs = ItemsSketch.getInstance(k, comparator);
        if (empty) {
            return qs;
        }
        long n = PreambleUtil.extractN(memObj, cumOffset);
        int extra = 2;
        int numMemItems = Util.computeRetainedItems(k, n) + 2;
        qs.n_ = n;
        qs.combinedBufferItemCapacity_ = Util.computeCombinedBufferItemCapacity(k, n);
        qs.baseBufferCount_ = Util.computeBaseBufferItems(k, n);
        qs.bitPattern_ = Util.computeBitPattern(k, n);
        qs.combinedBuffer_ = new Object[qs.combinedBufferItemCapacity_];
        int srcMemItemsOffsetBytes = preambleLongs * 8;
        MemoryRegion mReg = new MemoryRegion(srcMem, srcMemItemsOffsetBytes, srcMem.getCapacity() - (long)srcMemItemsOffsetBytes);
        T[] itemsArray = serDe.deserializeFromMemory(mReg, numMemItems);
        super.itemsArrayToCombinedBuffer(itemsArray);
        return qs;
    }

    static <T> ItemsSketch<T> copy(ItemsSketch<T> sketch) {
        ItemsSketch<? super T> qsCopy = ItemsSketch.getInstance(sketch.k_, sketch.comparator_);
        qsCopy.n_ = sketch.n_;
        qsCopy.minValue_ = sketch.getMinValue();
        qsCopy.maxValue_ = sketch.getMaxValue();
        qsCopy.combinedBufferItemCapacity_ = sketch.getCombinedBufferAllocatedCount();
        qsCopy.baseBufferCount_ = sketch.getBaseBufferCount();
        qsCopy.bitPattern_ = sketch.getBitPattern();
        Object[] combBuf = sketch.getCombinedBuffer();
        qsCopy.combinedBuffer_ = Arrays.copyOf(combBuf, combBuf.length);
        return qsCopy;
    }

    public void update(T dataItem) {
        if (dataItem == null) {
            return;
        }
        if (this.maxValue_ == null || this.comparator_.compare(dataItem, this.maxValue_) > 0) {
            this.maxValue_ = dataItem;
        }
        if (this.minValue_ == null || this.comparator_.compare(dataItem, this.minValue_) < 0) {
            this.minValue_ = dataItem;
        }
        if (this.baseBufferCount_ + 1 > this.combinedBufferItemCapacity_) {
            ItemsSketch.growBaseBuffer(this);
        }
        this.combinedBuffer_[this.baseBufferCount_++] = dataItem;
        ++this.n_;
        if (this.baseBufferCount_ == 2 * this.k_) {
            ItemsUtil.processFullBaseBuffer(this);
        }
    }

    public T getQuantile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new SketchesArgumentException("Fraction cannot be less than zero or greater than 1.0");
        }
        if (fraction == 0.0) {
            return this.minValue_;
        }
        if (fraction == 1.0) {
            return this.maxValue_;
        }
        ItemsAuxiliary<T> aux = this.constructAuxiliary();
        return aux.getQuantile(fraction);
    }

    public T[] getQuantiles(double[] fractions) {
        if (this.isEmpty()) {
            return null;
        }
        Util.validateFractions(fractions);
        ItemsAuxiliary<T> aux = null;
        Object[] answers = (Object[])Array.newInstance(this.minValue_.getClass(), fractions.length);
        for (int i = 0; i < fractions.length; ++i) {
            double fraction = fractions[i];
            if (fraction == 0.0) {
                answers[i] = this.minValue_;
                continue;
            }
            if (fraction == 1.0) {
                answers[i] = this.maxValue_;
                continue;
            }
            if (aux == null) {
                aux = this.constructAuxiliary();
            }
            answers[i] = aux.getQuantile(fraction);
        }
        return answers;
    }

    public T[] getQuantiles(int evenlySpaced) {
        return this.getQuantiles(ItemsSketch.getEvenlySpaced(evenlySpaced));
    }

    public double[] getPMF(T[] splitPoints) {
        return ItemsPmfCdfImpl.getPMFOrCDF(this, splitPoints, false);
    }

    public double[] getCDF(T[] splitPoints) {
        return ItemsPmfCdfImpl.getPMFOrCDF(this, splitPoints, true);
    }

    public int getK() {
        return this.k_;
    }

    public T getMinValue() {
        return this.minValue_;
    }

    public T getMaxValue() {
        return this.maxValue_;
    }

    public long getN() {
        return this.n_;
    }

    public double getNormalizedRankError() {
        return ItemsSketch.getNormalizedRankError(this.getK());
    }

    public static double getNormalizedRankError(int k) {
        return Util.EpsilonFromK.getAdjustedEpsilon(k);
    }

    public boolean isEmpty() {
        return this.getN() == 0L;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isEstimationMode() {
        return this.getN() >= 2L * (long)this.k_;
    }

    public void reset() {
        this.n_ = 0L;
        this.combinedBufferItemCapacity_ = 2 * Math.min(2, this.k_);
        this.combinedBuffer_ = new Object[this.combinedBufferItemCapacity_];
        this.baseBufferCount_ = 0;
        this.bitPattern_ = 0L;
        this.minValue_ = null;
        this.maxValue_ = null;
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        return this.toByteArray(false, serDe);
    }

    public byte[] toByteArray(boolean ordered, ArrayOfItemsSerDe<T> serDe) {
        return ItemsByteArrayImpl.toByteArray(this, ordered, serDe);
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        return ItemsUtil.toString(sketchSummary, dataDetail, this);
    }

    public ItemsSketch<T> downSample(int newK) {
        ItemsSketch<? super T> newSketch = ItemsSketch.getInstance(newK, this.comparator_);
        ItemsMergeImpl.downSamplingMergeInto(this, newSketch);
        return newSketch;
    }

    public int getRetainedItems() {
        return Util.computeRetainedItems(this.getK(), this.getN());
    }

    public void putMemory(Memory dstMem, ArrayOfItemsSerDe<T> serDe) {
        byte[] byteArr = this.toByteArray(serDe);
        long memCap = dstMem.getCapacity();
        if (memCap < (long)byteArr.length) {
            throw new SketchesArgumentException("Destination Memory not large enough: " + memCap + " < " + byteArr.length);
        }
        dstMem.putByteArray(0L, byteArr, 0, byteArr.length);
    }

    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    int getCombinedBufferAllocatedCount() {
        return this.combinedBufferItemCapacity_;
    }

    long getBitPattern() {
        return this.bitPattern_;
    }

    Object[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    Comparator<? super T> getComparator() {
        return this.comparator_;
    }

    private void itemsArrayToCombinedBuffer(T[] itemsArray) {
        long bits;
        int extra = 2;
        this.minValue_ = itemsArray[0];
        this.maxValue_ = itemsArray[1];
        System.arraycopy(itemsArray, 2, this.combinedBuffer_, 0, this.baseBufferCount_);
        if (bits > 0L) {
            int index = 2 + this.baseBufferCount_;
            int level = 0;
            for (bits = this.bitPattern_; bits != 0L; bits >>>= 1) {
                if ((bits & 1L) > 0L) {
                    System.arraycopy(itemsArray, index, this.combinedBuffer_, (2 + level) * this.k_, this.k_);
                    index += this.k_;
                }
                ++level;
            }
        }
    }

    private ItemsAuxiliary<T> constructAuxiliary() {
        return new ItemsAuxiliary(this);
    }

    private static double[] getEvenlySpaced(int n) {
        if (n <= 0) {
            throw new SketchesArgumentException("n must be > zero.");
        }
        double[] fractions = new double[n];
        fractions[0] = 0.0;
        for (int i = 1; i < n; ++i) {
            fractions[i] = (double)i / (double)(n - 1);
        }
        if (n > 1) {
            fractions[n - 1] = 1.0;
        }
        return fractions;
    }

    private static <T> void growBaseBuffer(ItemsSketch<T> sketch) {
        int newSize;
        Object[] baseBuffer = sketch.getCombinedBuffer();
        int oldSize = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        assert (oldSize < 2 * k);
        sketch.combinedBufferItemCapacity_ = newSize = Math.max(Math.min(2 * k, 2 * oldSize), 1);
        sketch.combinedBuffer_ = Arrays.copyOf(baseBuffer, newSize);
    }
}

